/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.io.JSWriter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RDFJSONWriter
extends WriterGraphRIOTBase {
    public static void output(OutputStream out, Graph graph) {
        RDFJSONWriter.output(new JSWriter(out), graph);
    }

    public static void output(Writer out, Graph graph) {
        RDFJSONWriter.output(new JSWriter(new IndentedWriterEx(out)), graph);
    }

    @Override
    public Lang getLang() {
        return Lang.RDFJSON;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        RDFJSONWriter.output(out, graph);
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        RDFJSONWriter.output(out, graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(JSWriter out, Graph graph) {
        out.startOutput();
        out.startObject();
        ExtendedIterator<Node> subjects = GraphUtil.listSubjects(graph, Node.ANY, Node.ANY);
        try {
            HashMap predicates = new HashMap();
            while (subjects.hasNext()) {
                Node subject = (Node)subjects.next();
                try (ExtendedIterator<Triple> triples = graph.find(subject, Node.ANY, Node.ANY);){
                    while (triples.hasNext()) {
                        Triple triple = (Triple)triples.next();
                        Node p = triple.getPredicate();
                        if (predicates.containsKey(p)) {
                            ((Set)predicates.get(p)).add(triple.getObject());
                            continue;
                        }
                        HashSet<Node> objects = new HashSet<Node>();
                        objects.add(triple.getObject());
                        predicates.put(p, objects);
                    }
                }
                RDFJSONWriter.send(out, new Pair<Node, Map<Node, Set<Node>>>(subject, predicates));
                predicates.clear();
            }
        }
        finally {
            if (subjects != null) {
                subjects.close();
            }
            out.finishObject();
            out.finishOutput();
        }
    }

    private static void send(JSWriter out, Pair<Node, Map<Node, Set<Node>>> item) {
        Node s = item.getLeft();
        if (s.isBlank()) {
            out.key("_:" + s.getBlankNodeLabel());
        } else if (s.isURI()) {
            out.key(s.getURI());
        } else {
            throw new RiotException("Only URIs or blank nodes are legal subjects.");
        }
        out.startObject();
        Map<Node, Set<Node>> predicates = item.getRight();
        for (Node p : predicates.keySet()) {
            out.key(p.getURI());
            out.startArray();
            Set<Node> objects = predicates.get(p);
            int i = 0;
            for (Node o : objects) {
                out.startObject();
                if (o.isBlank()) {
                    out.pair("type", "bnode");
                    out.pair("value", "_:" + o.getBlankNodeLabel());
                } else if (o.isURI()) {
                    out.pair("type", "uri");
                    out.pair("value", o.getURI());
                } else if (o.isLiteral()) {
                    String lex = o.getLiteralLexicalForm();
                    out.pair("type", "literal");
                    out.pair("value", lex);
                    if (!NodeUtils.isSimpleString(o)) {
                        if (NodeUtils.isLangString(o)) {
                            String lang = o.getLiteralLanguage();
                            out.pair("lang", lang);
                        } else {
                            String dt = o.getLiteralDatatypeURI();
                            out.pair("datatype", dt);
                        }
                    }
                }
                out.finishObject();
                if (i < objects.size() - 1) {
                    out.arraySep();
                }
                ++i;
            }
            out.finishArray();
        }
        out.finishObject();
    }

    private static class IndentedWriterEx
    extends IndentedWriter {
        public IndentedWriterEx(Writer writer) {
            super(writer);
        }
    }
}

