/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.Quad;

public class FactoryRDFStd
implements FactoryRDF {
    private final LabelToNode labelMapping;
    private static Node scope = null;

    public FactoryRDFStd() {
        this(SyntaxLabels.createLabelToNode());
    }

    public FactoryRDFStd(LabelToNode labelMapping) {
        this.labelMapping = labelMapping;
    }

    @Override
    public Triple createTriple(Node subject, Node predicate, Node object) {
        return Triple.create(subject, predicate, object);
    }

    @Override
    public Quad createQuad(Node graph, Node subject, Node predicate, Node object) {
        return Quad.create(graph, subject, predicate, object);
    }

    @Override
    public Node createURI(String uriStr) {
        return RiotLib.createIRIorBNode(uriStr);
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype) {
        return NodeFactory.createLiteralDT(lexical, datatype);
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag) {
        return NodeFactory.createLiteralLang(lexical, langTag);
    }

    @Override
    public Node createLangDirLiteral(String lexical, String langTag, String direction) {
        return NodeFactory.createLiteralDirLang(lexical, langTag, direction);
    }

    @Override
    public Node createStringLiteral(String lexical) {
        return NodeFactory.createLiteralString(lexical);
    }

    @Override
    public Node createBlankNode(long mostSigBits, long leastSigBits) {
        return this.createBlankNode(String.format("%08X%08X", mostSigBits, leastSigBits));
    }

    @Override
    public Node createBlankNode(String label) {
        return (Node)this.labelMapping.get(scope, label);
    }

    @Override
    public Node createBlankNode() {
        return (Node)this.labelMapping.create();
    }

    @Override
    public void reset() {
        this.labelMapping.clear();
    }
}

