/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.protobuf.PBufRDF;
import org.apache.jena.riot.protobuf.ProtobufConvert;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;

public class Binding2Protobuf
implements AutoCloseable {
    private final PB_RDF.RDF_DataTuple.Builder row = PB_RDF.RDF_DataTuple.newBuilder();
    private final PB_RDF.RDF_Term.Builder term = PB_RDF.RDF_Term.newBuilder();
    private final Collection<Var> vars;
    private final OutputStream out;
    private final boolean encodeValues;

    public Binding2Protobuf(OutputStream out, Collection<Var> vars, boolean encodeValues) {
        this.out = out;
        this.vars = vars;
        this.encodeValues = encodeValues;
        this.varsRow();
    }

    private void varsRow() {
        PB_RDF.RDF_VarTuple.Builder vrow = PB_RDF.RDF_VarTuple.newBuilder();
        PB_RDF.RDF_Var.Builder var = PB_RDF.RDF_Var.newBuilder();
        this.vars.forEach(v -> {
            var.clear();
            var.setName(v.getVarName());
            vrow.addVars(var);
        });
        PBufRDF.writeDelimitedTo(vrow.build(), this.out);
    }

    public void output(Binding binding) {
        Iterator<Var> vIter;
        this.row.clear();
        Iterator<Var> iterator = vIter = this.vars == null ? null : this.vars.iterator();
        if (vIter == null) {
            vIter = binding.vars();
        }
        vIter.forEachRemaining(v -> {
            this.term.clear();
            Node n = binding.get((Var)v);
            PB_RDF.RDF_Term rt = ProtobufConvert.toProtobuf(n, this.term, this.encodeValues);
            this.row.addRow(rt);
        });
        PBufRDF.writeDelimitedTo(this.row.build(), this.out);
    }

    @Override
    public void close() {
    }
}

