/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.extra;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.lang.extra.javacc.ParseException;
import org.apache.jena.riot.lang.extra.javacc.TokenMgrError;
import org.apache.jena.riot.lang.extra.javacc.TurtleJavacc;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;

public class TurtleJavaccReaderRIOT
implements ReaderRIOT {
    private final ParserProfile profile;

    public TurtleJavaccReaderRIOT(ParserProfile profile) {
        this.profile = profile;
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        BufferedReader r = IO.asBufferedUTF8(in);
        TurtleJavacc parser = new TurtleJavacc(r);
        this.read(parser, baseURI, ct, output, context2);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        TurtleJavacc parser = new TurtleJavacc(reader);
        this.read(parser, baseURI, ct, output, context2);
    }

    private void read(TurtleJavacc parser, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        parser.setDest(output);
        parser.setProfile(this.profile);
        try {
            output.start();
            parser.parse();
            output.finish();
        }
        catch (ParseException ex) {
            this.profile.getErrorHandler().error(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
            throw new RiotParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError ex) {
            this.profile.getErrorHandler().error(ex.getMessage(), -1L, -1L);
            throw new RiotParseException(ex.getMessage(), -1L, -1L);
        }
    }
}

