/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri3986.provider;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.jena.iri3986.provider.IssueGroup;
import org.apache.jena.iri3986.provider.Issues;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIx;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.Issue;
import org.apache.jena.rfc3986.RFC3986;
import org.apache.jena.rfc3986.Severity;
import org.apache.jena.rfc3986.SeverityMap;
import org.apache.jena.rfc3986.Violations;

public class IRIProvider3986
implements IRIProvider {
    private static IRIx newIRIx(IRI3986 iri2) {
        return IRIProvider3986.newIRIx(iri2.toString(), iri2);
    }

    private static IRIx newIRIx(String iriStr, IRI3986 iri2) {
        return new IRIx3986(iriStr, iri2);
    }

    @Override
    public IRIx create(String iriStr) throws IRIException {
        IRI3986 iri2 = IRIProvider3986.create3986(iriStr);
        return IRIProvider3986.newIRIx(iriStr, iri2);
    }

    @Override
    public void check(String iriStr) throws IRIException {
        IRI3986 iri2 = IRIProvider3986.create3986(iriStr);
    }

    private static IRI3986 create3986(String iriStr) {
        IRI3986 iri2 = IRI3986.createAny(iriStr);
        IRIProvider3986.violationsOnCreation(iri2);
        return iri2;
    }

    private static void violationsOnCreation(IRI3986 iri2) {
        if (iri2.hasViolations()) {
            IRIProvider3986.violationsOnCreation(iri2, Violations.severities());
        }
    }

    private static void violationsOnCreation(IRI3986 iri2, SeverityMap severityMap) {
        iri2.forEachViolation(v -> {
            Issue issue = v.issue();
            boolean isStrict = Issues.isStrict(issue);
            Severity severity = severityMap.get(issue);
            if (isStrict) {
                switch (severity) {
                    case INVALID: 
                    case ERROR: {
                        throw new IRIException(v.message());
                    }
                }
            } else {
                switch (severity) {
                    case INVALID: {
                        throw new IRIException(v.message());
                    }
                }
            }
        });
    }

    @Override
    public void strictMode(String schemeName, boolean strictness) {
        Objects.requireNonNull(schemeName);
        IssueGroup issueGroup = Issues.getScheme(schemeName);
        if (issueGroup == null) {
            throw new IllegalArgumentException("Scheme name '" + schemeName + "' not recognized as an issues group");
        }
        Issues.setStrictness(issueGroup, strictness);
    }

    @Override
    public boolean isStrictMode(String schemeName) {
        IssueGroup issueGroup = Issues.getScheme(schemeName);
        if (issueGroup == null) {
            return true;
        }
        return Issues.isStrict(issueGroup);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class IRIx3986
    extends IRIx {
        private final IRI3986 iri;

        private IRIx3986(String iriStr, IRI3986 iri2) {
            super(iri2.toString());
            this.iri = iri2;
        }

        @Override
        public boolean isAbsolute() {
            return this.iri.isAbsolute();
        }

        @Override
        public boolean isRelative() {
            return this.iri.isRelative();
        }

        @Override
        public boolean isReference() {
            if (this.iri.isRootless()) {
                return true;
            }
            return this.iri.hasScheme();
        }

        @Override
        public boolean hasScheme(String scheme) {
            String iriScheme = this.scheme();
            if (iriScheme == null) {
                return false;
            }
            return iriScheme.equalsIgnoreCase(scheme);
        }

        @Override
        public String scheme() {
            return this.iri.scheme();
        }

        @Override
        public IRIx resolve(String other) {
            IRI3986 iriOther = IRIProvider3986.create3986(other);
            IRI3986 iri2 = this.iri.resolve(iriOther);
            return IRIProvider3986.newIRIx(iri2);
        }

        @Override
        public IRIx resolve(IRIx other) {
            IRIx3986 iriOther = (IRIx3986)other;
            IRI3986 iri2 = this.iri.resolve(iriOther.iri);
            return IRIProvider3986.newIRIx(iri2);
        }

        @Override
        public IRIx normalize() {
            IRI3986 iri3986 = RFC3986.normalize(this.iri);
            return IRIProvider3986.newIRIx(iri3986);
        }

        @Override
        public IRIx relativize(IRIx other) {
            IRIx3986 iriOther = (IRIx3986)other;
            IRI3986 iri2 = this.iri.relativize(iriOther.iri);
            return iri2 == null ? null : IRIProvider3986.newIRIx(iri2);
        }

        @Override
        public IRI3986 getImpl() {
            return this.iri;
        }

        @Override
        public boolean hasViolations() {
            return this.iri.hasViolations(Severity.IGNORE);
        }

        @Override
        public void handleViolations(BiConsumer<Boolean, String> handler) {
            this.iri.forEachViolation(v -> {
                Severity severity = Violations.getSeverity(v.issue());
                String msg = v.message();
                switch (severity) {
                    case INVALID: {
                        throw new IRIException(msg);
                    }
                    case ERROR: {
                        handler.accept(Boolean.TRUE, msg);
                        break;
                    }
                    case WARNING: {
                        handler.accept(Boolean.FALSE, msg);
                        break;
                    }
                    case IGNORE: {
                        break;
                    }
                }
            });
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.iri);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IRIx3986 other = (IRIx3986)obj;
            return Objects.equals(this.iri, other.iri);
        }
    }
}

