/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.atlas.logging.LogCtlJUL;
import org.apache.jena.geosparql.assembler.GeoAssembler;
import org.apache.jena.geosparql.assembler.VocabGeoSPARQL;
import org.apache.jena.geosparql.configuration.GeoSPARQLConfig;
import org.apache.jena.geosparql.implementation.datatype.GeometryDatatype;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSubsystemLifecycle;
import org.apache.jena.sys.JenaSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitGeoSPARQL
implements JenaSubsystemLifecycle {
    private static volatile boolean initialized = false;
    private static Object initLock = new Object();

    @Override
    public void start() {
        InitGeoSPARQL.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = initLock;
        synchronized (object) {
            if (initialized || System.getProperty("jena.geosparql.skip", "false").equalsIgnoreCase("true")) {
                JenaSystem.logLifecycle("InitGeoSPARQL - skip", new Object[0]);
                return;
            }
            initialized = true;
            LogCtlJUL.routeJULtoSLF4J();
            JenaSystem.logLifecycle("InitGeoSPARQL - start", new Object[0]);
            GeometryDatatype.registerDatatypes();
            Logger SIS_SystemLogger = LoggerFactory.getLogger("org.apache.sis.system");
            LogCtl.withLevel(SIS_SystemLogger, "ERROR", () -> GeoSPARQLConfig.loadFunctions());
            GeoAssembler assembler = new GeoAssembler();
            AssemblerUtils.registerDataset(VocabGeoSPARQL.tGeoDataset, assembler);
            AssemblerUtils.registerDataset(VocabGeoSPARQL.tGeoDatasetAlt, assembler);
            JenaSystem.logLifecycle("InitGeoSPARQL - finish", new Object[0]);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public int level() {
        return 100;
    }
}

