/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.sys;

import java.util.ArrayList;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class JettyLib {
    public static void addHandler(Server server, Handler handler) {
        Handler currentHandler = server.getHandler();
        if (currentHandler == null) {
            server.setHandler(handler);
        } else {
            ArrayList<Handler> handlerList = new ArrayList<Handler>();
            if (currentHandler instanceof Handler.Container) {
                Handler.Container hContainer = (Handler.Container)currentHandler;
                handlerList.addAll(hContainer.getHandlers());
            }
            handlerList.add(handler);
            Handler.Sequence container2 = new Handler.Sequence(handlerList);
            server.setHandler(container2);
        }
    }

    public static void setMimeTypes(ServletContextHandler context2) {
        MimeTypes.Mutable mimeTypes = context2.getMimeTypes();
        mimeTypes.addMimeMapping("nt", "application/n-triples");
        mimeTypes.addMimeMapping("nq", "application/n-quads");
        mimeTypes.addMimeMapping("ttl", "text/turtle");
        mimeTypes.addMimeMapping("trig", "application/trig");
        mimeTypes.addMimeMapping("rdf", "application/rdf+xml");
        mimeTypes.addMimeMapping("jsonld", "application/ld+json");
        mimeTypes.addMimeMapping("rj", "application/rdf+json");
        mimeTypes.addMimeMapping("rt", "application/rdf+thrift");
        mimeTypes.addMimeMapping("trdf", "application/rdf+thrift");
        mimeTypes.addMimeMapping("rq", "application/sparql-query");
        mimeTypes.addMimeMapping("ru", "application/sparql-update");
        mimeTypes.addMimeMapping("rsj", "application/sparql-results+json");
        mimeTypes.addMimeMapping("rsx", "application/sparql-results+xml");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+thrift");
        mimeTypes.addMimeMapping("srt", "application/sparql-results+protobuf");
        mimeTypes.addMimeMapping("txt", "text/plain");
        mimeTypes.addMimeMapping("csv", "text/csv");
        mimeTypes.addMimeMapping("tsv", "text/tab-separated-values");
    }

    public static HttpConfiguration httpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setRequestHeaderSize(524288);
        httpConfig.setResponseHeaderSize(16384);
        httpConfig.setOutputBufferSize(0x500000);
        httpConfig.setSendServerVersion(false);
        return httpConfig;
    }

    public static Resource newResource(String filename) {
        return ResourceFactory.root().newResource(filename);
    }
}

