/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction;

import java.nio.ByteBuffer;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.SysTransState;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransLogger
implements TransactionalComponent {
    private final Logger log;
    private final boolean everyEvent;

    public TransLogger() {
        this(null, false);
    }

    public TransLogger(Logger logger) {
        this(logger, false);
    }

    public TransLogger(Logger logger, boolean all) {
        if (logger == null) {
            logger = LoggerFactory.getLogger(TransLogger.class);
        }
        this.log = logger;
        this.everyEvent = all;
    }

    @Override
    public ComponentId getComponentId() {
        return null;
    }

    @Override
    public void startRecovery() {
        if (this.everyEvent) {
            this.log.info("startRecovery");
        }
    }

    @Override
    public void recover(ByteBuffer ref) {
        if (this.everyEvent) {
            this.log.info("recover");
        }
    }

    @Override
    public void finishRecovery() {
        if (this.everyEvent) {
            this.log.info("finishRecovery");
        }
    }

    @Override
    public void cleanStart() {
        if (this.everyEvent) {
            this.log.info("cleanStart");
        }
    }

    @Override
    public void begin(Transaction transaction) {
        this.txnStep("begin", transaction);
    }

    @Override
    public boolean promote(Transaction transaction) {
        this.txnStep("promote", transaction);
        return true;
    }

    @Override
    public ByteBuffer commitPrepare(Transaction transaction) {
        if (this.everyEvent) {
            this.txnStep("commitPrepare", transaction);
        }
        return null;
    }

    @Override
    public void commit(Transaction transaction) {
        this.txnStep("commit", transaction);
    }

    @Override
    public void commitEnd(Transaction transaction) {
        if (this.everyEvent) {
            this.txnStep("commitEnd", transaction);
        }
    }

    @Override
    public void abort(Transaction transaction) {
        this.txnStep("abort", transaction);
    }

    @Override
    public void complete(Transaction transaction) {
        this.txnStep("complete", transaction);
    }

    @Override
    public SysTransState detach() {
        this.log.info("detach");
        return null;
    }

    @Override
    public void attach(SysTransState systemState) {
        this.log.info("attach");
    }

    @Override
    public void shutdown() {
        if (this.everyEvent) {
            this.log.info("shutdown");
        }
    }

    private void txnStep(String opName, Transaction transaction) {
        FmtLog.info(this.log, "%-8s %s", transaction.getTxnId(), opName);
    }
}

