/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.JsonVisitor;

public class JsonObject
extends JsonValue {
    private final Map<String, JsonValue> map = new LinkedHashMap<String, JsonValue>();

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject getAsObject() {
        return this;
    }

    @Override
    public void visit(JsonVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof JsonObject)) {
            return false;
        }
        return this.map.equals(((JsonObject)other).map);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean hasKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<String> keys() {
        return this.map.keySet();
    }

    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.map.entrySet();
    }

    public JsonValue get(String key) {
        return this.map.get(key);
    }

    public JsonObject getObj(String key) {
        return this.get(key).getAsObject();
    }

    public Number getNumber(String key) {
        return this.get(key).getAsNumber().value();
    }

    public String getString(String key) {
        return this.get(key).getAsString().value();
    }

    public boolean getBoolean(String key) {
        return this.get(key).getAsBoolean().value();
    }

    public Stream<JsonValue> getArray(String key) {
        return this.get(key).getAsArray().stream();
    }

    public Iterator<JsonValue> getIterator(String key) {
        return this.get(key).getAsArray().iterator();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public void forEach(BiConsumer<String, JsonValue> action) {
        this.map.forEach(action);
    }

    public JsonValue put(String key, JsonValue value) {
        return this.map.put(key, value);
    }

    public JsonValue put(String key, String value) {
        return this.map.put(key, new JsonString(value));
    }

    public JsonValue put(String key, long value) {
        return this.map.put(key, JsonNumber.value(value));
    }

    public JsonValue put(String key, boolean b) {
        return this.map.put(key, new JsonBoolean(b));
    }

    public void putAll(Map<? extends String, ? extends JsonValue> m) {
        this.map.putAll(m);
    }

    public JsonValue remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<JsonValue> values() {
        return this.map.values();
    }
}

