/*
 * Decompiled with CFR 0.152.
 */
package tdb2.xloader;

import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.tdb2.xloader.ProcBuildNodeTableX;
import tdb2.xloader.AbstractCmdxLoad;

public class CmdxBuildNodeTable
extends AbstractCmdxLoad {
    public static void main(String ... args) {
        new CmdxBuildNodeTable(args).mainRun();
    }

    protected CmdxBuildNodeTable(String[] argv) {
        super("Nodes", argv);
    }

    @Override
    protected void setCmdArgs() {
        super.add(argLocation, "--loc=", "Database location");
        super.add(argTmpdir, "--tmpdir=", "Temporary directory (defaults to --loc)");
        super.add(argSortThreads, "--threads=", "Number of threads; passed as an argument to sort(1)");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + this.getArgsSummary();
    }

    @Override
    protected void subCheckArgs() {
        if (this.location == null) {
            throw new CmdException("Required : --loc");
        }
        if (this.filenames.isEmpty()) {
            throw new CmdException("No files to load");
        }
    }

    @Override
    protected String getCommandName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected void exec() {
        FileOps.ensureDir(this.location);
        FileOps.clearAll(this.location);
        if (this.tmpdir == null) {
            this.tmpdir = this.location;
        }
        ProcBuildNodeTableX.exec(this.location, this.loaderFiles, this.sortThreads, this.sortNodeTableArgs, this.filenames);
    }
}

