/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import java.util.regex.Pattern;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.AuthalicConversion;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.LambertCylindricalEqualArea;
import org.apache.sis.referencing.operation.provider.Mercator1SP;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.internal.DoubleDouble;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CylindricalEqualArea
extends AuthalicConversion {
    private static final long serialVersionUID = 5659955047326708663L;
    private final Variant variant;

    public CylindricalEqualArea(OperationMethod method, Parameters parameters) {
        this(CylindricalEqualArea.initializer(method, parameters));
    }

    private static Initializer initializer(OperationMethod method, Parameters parameters) {
        Variant variant = (Variant)CylindricalEqualArea.variant((OperationMethod)method, (ProjectionVariant[])Variant.values(), (ProjectionVariant)Variant.ELLIPSOIDAL);
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.SCALE_FACTOR, LambertCylindricalEqualArea.SCALE_FACTOR);
        roles.put(NormalizedProjection.ParameterRole.FALSE_EASTING, LambertCylindricalEqualArea.FALSE_EASTING);
        roles.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, LambertCylindricalEqualArea.FALSE_NORTHING);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, LambertCylindricalEqualArea.LONGITUDE_OF_ORIGIN);
        return new Initializer(method, parameters, roles, variant);
    }

    private CylindricalEqualArea(Initializer initializer) {
        super(initializer, null);
        this.variant = (Variant)initializer.variant;
        double \u03c61 = Math.toRadians(initializer.getAndStore(LambertCylindricalEqualArea.STANDARD_PARALLEL));
        DoubleDouble k0 = DoubleDouble.of(initializer.scaleAt\u03c6(Math.sin(\u03c61), Math.cos(\u03c61)), false).multiply(initializer.getAndStore(Mercator1SP.SCALE_FACTOR), true);
        DoubleDouble ik = DoubleDouble.ONE.subtract(initializer.eccentricitySquared);
        ik = ik.scalb(-1);
        ik = ik.divide(k0);
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        denormalize.convertAfter(0, k0, null);
        denormalize.convertAfter(1, ik, null);
    }

    CylindricalEqualArea(CylindricalEqualArea other) {
        super(other);
        this.variant = other.variant;
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        CylindricalEqualArea kernel = this;
        if (this.variant == Variant.SPHERICAL || this.eccentricity == 0.0) {
            kernel = new Spherical(this);
        }
        return this.context.completeTransform(factory, kernel);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6 = Math.sin(\u03c6);
        if (dstPts != null) {
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = this.qm(sin\u03c6);
        }
        return derivate ? new Matrix2(1.0, 0.0, 0.0, this.dqm_d\u03c6(sin\u03c6, Math.cos(\u03c6))) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        if (srcPts != dstPts || srcOff != dstOff || this.getClass() != CylindricalEqualArea.class) {
            super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
        } else {
            --dstOff;
            while (--numPts >= 0) {
                double \u03c6 = dstPts[dstOff += 2];
                dstPts[dstOff] = this.qm(Math.sin(\u03c6));
            }
        }
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double y = srcPts[srcOff + 1];
        dstPts[dstOff] = srcPts[srcOff];
        dstPts[dstOff + 1] = this.\u03c6(y / this.qmPolar);
    }

    private static enum Variant implements ProjectionVariant
    {
        ELLIPSOIDAL(null, "9835"),
        SPHERICAL(Pattern.compile(".*\\bSpherical\\b.*", 2), "9834");

        private final Pattern operationName;
        private final String identifier;

        private Variant(Pattern operationName, String identifier) {
            this.operationName = operationName;
            this.identifier = identifier;
        }

        @Override
        public Pattern getOperationNamePattern() {
            return this.operationName;
        }

        @Override
        public String getIdentifier() {
            return this.identifier;
        }

        @Override
        public boolean useAuthalicRadius() {
            return this == SPHERICAL;
        }
    }

    private static final class Spherical
    extends CylindricalEqualArea {
        private static final long serialVersionUID = 1063449347697947732L;

        Spherical(CylindricalEqualArea other) {
            super(other);
            this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION).convertAfter(1, 2, null);
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
            double \u03c6 = srcPts[srcOff + 1];
            if (dstPts != null) {
                dstPts[dstOff] = srcPts[srcOff];
                dstPts[dstOff + 1] = Math.sin(\u03c6);
            }
            return derivate ? new Matrix2(1.0, 0.0, 0.0, Math.cos(\u03c6)) : null;
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts != dstPts || srcOff != dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                --dstOff;
                while (--numPts >= 0) {
                    double \u03c6 = dstPts[dstOff += 2];
                    dstPts[dstOff] = Math.sin(\u03c6);
                }
            }
        }

        @Override
        protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) {
            double y = srcPts[srcOff + 1];
            dstPts[dstOff] = srcPts[srcOff];
            dstPts[dstOff + 1] = Math.asin(y);
        }
    }
}

