/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.quality.AbstractDataEvaluation;
import org.apache.sis.metadata.iso.quality.DefaultAggregationDerivation;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CloneAccess;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_EvaluationMethod_Type", propOrder={"evaluationMethodType", "evaluationMethodDescription", "evaluationProcedure", "referenceDocuments", "dates"})
@XmlRootElement(name="DQ_EvaluationMethod")
@XmlSeeAlso(value={AbstractDataEvaluation.class, DefaultAggregationDerivation.class})
@UML(identifier="DQ_EvaluationMethod", specification=Specification.UNSPECIFIED)
public class DefaultEvaluationMethod
extends ISOMetadata {
    private static final long serialVersionUID = 5196994626251088685L;
    private EvaluationMethodType evaluationMethodType;
    private InternationalString evaluationMethodDescription;
    private Citation evaluationProcedure;
    private Collection<Citation> referenceDocuments;
    private Dates dates;

    public DefaultEvaluationMethod() {
    }

    public DefaultEvaluationMethod(DefaultEvaluationMethod object) {
        super(object);
        if (object != null) {
            this.evaluationMethodType = object.getEvaluationMethodType();
            this.evaluationMethodDescription = object.getEvaluationMethodDescription();
            this.evaluationProcedure = object.getEvaluationProcedure();
            this.referenceDocuments = this.copyCollection(object.getReferenceDocuments(), Citation.class);
            this.writeDates(object.getDates());
        }
    }

    @XmlElement(name="evaluationMethodType")
    @UML(identifier="evaluationMethodType", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public EvaluationMethodType getEvaluationMethodType() {
        return this.evaluationMethodType;
    }

    public void setEvaluationMethodType(EvaluationMethodType newValue) {
        this.checkWritePermission(this.evaluationMethodType);
        this.evaluationMethodType = newValue;
    }

    @XmlElement(name="evaluationMethodDescription")
    @UML(identifier="evaluationMethodDescription", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public InternationalString getEvaluationMethodDescription() {
        return this.evaluationMethodDescription;
    }

    public void setEvaluationMethodDescription(InternationalString newValue) {
        this.checkWritePermission(this.evaluationMethodDescription);
        this.evaluationMethodDescription = newValue;
    }

    @XmlElement(name="evaluationProcedure")
    @UML(identifier="evaluationProcedure", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Citation getEvaluationProcedure() {
        return this.evaluationProcedure;
    }

    public void setEvaluationProcedure(Citation newValue) {
        this.checkWritePermission(this.evaluationProcedure);
        this.evaluationProcedure = newValue;
    }

    @XmlElement(name="referenceDoc")
    @UML(identifier="referenceDoc", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Citation> getReferenceDocuments() {
        this.referenceDocuments = this.nonNullCollection(this.referenceDocuments, Citation.class);
        return this.referenceDocuments;
    }

    public void setReferenceDocuments(Collection<? extends Citation> newValues) {
        this.referenceDocuments = this.writeCollection(newValues, this.referenceDocuments, Citation.class);
    }

    @XmlElement(name="dateTime")
    @UML(identifier="dateTime", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public Collection<Temporal> getDates() {
        if (Semaphores.query(1)) {
            return Containers.isNullOrEmpty(this.dates) ? null : this.dates;
        }
        if (this.dates == null) {
            this.dates = new Dates();
        }
        return this.dates;
    }

    public void setDates(Collection<? extends Temporal> newValues) {
        if (newValues != this.dates) {
            this.checkWritePermission(ImplementationHelper.valueIfDefined(this.dates));
            this.writeDates(newValues);
        }
    }

    private void writeDates(Collection<? extends Temporal> newValues) {
        if (Containers.isNullOrEmpty(newValues)) {
            this.dates = null;
        } else {
            if (this.dates == null) {
                this.dates = new Dates();
            }
            this.dates.clear();
            this.dates.addAll(newValues);
        }
    }

    private static final class Dates
    extends AbstractList<Temporal>
    implements CheckedContainer<Temporal>,
    CloneAccess,
    Serializable {
        private static final long serialVersionUID = 1210175223467194009L;
        private Temporal date1;
        private Temporal date2;

        Dates() {
            this.clear();
        }

        @Override
        public Class<Temporal> getElementType() {
            return Temporal.class;
        }

        @Override
        public void clear() {
            this.date1 = null;
            this.date2 = null;
        }

        @Override
        public int size() {
            if (this.date2 != null) {
                return 2;
            }
            if (this.date1 != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public Temporal get(int index) {
            Temporal date2;
            switch (index) {
                case 0: {
                    date2 = this.date1;
                    break;
                }
                case 1: {
                    date2 = this.date2;
                    break;
                }
                default: {
                    date2 = null;
                }
            }
            if (date2 == null) {
                throw new IndexOutOfBoundsException(Errors.format((short)71, index));
            }
            return date2;
        }

        @Override
        public Temporal set(int index, Temporal date2) {
            ArgumentChecks.ensureNonNull("date", date2);
            Temporal previous = this.get(index);
            switch (index) {
                case 0: {
                    this.date1 = date2;
                    break;
                }
                case 1: {
                    this.date2 = date2;
                }
            }
            ++this.modCount;
            return previous;
        }

        @Override
        public Temporal remove(int index) {
            Temporal previous = this.get(index);
            switch (index) {
                case 0: {
                    this.date1 = this.date2;
                }
                case 1: {
                    this.date2 = null;
                }
            }
            ++this.modCount;
            return previous;
        }

        @Override
        public void add(int index, Temporal date2) {
            if (this.date2 == null) {
                switch (index) {
                    case 0: {
                        this.date2 = this.date1;
                        this.date1 = date2;
                        ++this.modCount;
                        return;
                    }
                    case 1: {
                        if (this.date1 == null) break;
                        this.date2 = date2;
                        ++this.modCount;
                        return;
                    }
                }
            }
            throw new IndexOutOfBoundsException(Errors.format((short)71, index));
        }

        @Override
        public boolean addAll(Collection<? extends Temporal> dates) {
            int c = this.modCount++;
            if (dates != null) {
                Iterator<? extends Temporal> it = dates.iterator();
                switch (this.size()) {
                    case 0: {
                        if (!it.hasNext()) break;
                        this.date1 = it.next();
                    }
                    case 1: {
                        if (!it.hasNext()) break;
                        this.date2 = it.next();
                        ++this.modCount;
                    }
                    default: {
                        if (!it.hasNext()) break;
                        throw new IllegalArgumentException(Errors.format((short)35, "dates", 2, dates.size()));
                    }
                }
            }
            return this.modCount != c;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }
}

