/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.lang.codec.Base64;
import org.apache.shiro.lang.codec.Hex;
import org.apache.shiro.lang.util.ByteSource;

public abstract class AbstractCryptHash
implements Hash,
Serializable {
    protected static final Pattern DELIMITER = Pattern.compile("\\$");
    private static final long serialVersionUID = 2483214646921027859L;
    private final String algorithmName;
    private final byte[] hashedData;
    private final ByteSource salt;
    private String hexEncoded;
    private String base64Encoded;

    public AbstractCryptHash(String algorithmName, byte[] hashedData, ByteSource salt) {
        this.algorithmName = algorithmName;
        this.hashedData = Arrays.copyOf(hashedData, hashedData.length);
        this.salt = Objects.requireNonNull(salt);
        this.checkValid();
    }

    protected final void checkValid() {
        this.checkValidAlgorithm();
        this.checkValidSalt();
    }

    protected abstract void checkValidAlgorithm();

    protected void checkValidSalt() {
        int length = this.salt.getBytes().length;
        if (length != this.getSaltLength()) {
            String message = String.format(Locale.ENGLISH, "Salt length is expected to be [%d] bytes, but was [%d] bytes.", this.getSaltLength(), length);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public abstract int getSaltLength();

    @Override
    public ByteSource getSalt() {
        return this.salt;
    }

    @Override
    public byte[] getBytes() {
        return Arrays.copyOf(this.hashedData, this.hashedData.length);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String toHex() {
        if (this.hexEncoded == null) {
            this.hexEncoded = Hex.encodeToString(this.formatToCryptString().getBytes(StandardCharsets.UTF_8));
        }
        return this.hexEncoded;
    }

    @Override
    public String toBase64() {
        if (this.base64Encoded == null) {
            this.base64Encoded = Base64.encodeToString(this.formatToCryptString().getBytes(StandardCharsets.UTF_8));
        }
        return this.base64Encoded;
    }

    public abstract String formatToCryptString();

    public boolean equals(Object other) {
        if (other instanceof AbstractCryptHash) {
            AbstractCryptHash that = (AbstractCryptHash)other;
            return this.formatToCryptString().equals(that.formatToCryptString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.formatToCryptString());
    }

    public String toString() {
        return new StringJoiner(", ", AbstractCryptHash.class.getSimpleName() + "[", "]").add("super=" + super.toString()).add("algorithmName='" + this.algorithmName + "'").add("hashedData=" + Arrays.toString(this.hashedData)).add("salt=" + String.valueOf(this.salt)).add("hexEncoded='" + this.hexEncoded + "'").add("base64Encoded='" + this.base64Encoded + "'").toString();
    }
}

