/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene99;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.OffHeapQuantizedByteVectorValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.quantization.QuantizedByteVectorValues;
import org.apache.lucene.util.quantization.QuantizedVectorsReader;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public final class Lucene99ScalarQuantizedVectorsReader
extends FlatVectorsReader
implements QuantizedVectorsReader {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Lucene99ScalarQuantizedVectorsReader.class);
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput quantizedVectorData;
    private final FlatVectorsReader rawVectorsReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene99ScalarQuantizedVectorsReader(SegmentReadState state, FlatVectorsReader rawVectorsReader, FlatVectorsScorer scorer) throws IOException {
        super(scorer);
        this.rawVectorsReader = rawVectorsReader;
        int versionMeta = -1;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vemq");
        boolean success = false;
        try {
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "Lucene99ScalarQuantizedVectorsFormatMeta", 0, 1, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, versionMeta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    priorE = exception;
                }
                finally {
                    CodecUtil.checkFooter(meta, priorE);
                }
                this.quantizedVectorData = Lucene99ScalarQuantizedVectorsReader.openDataInput(state, versionMeta, "veq", "Lucene99ScalarQuantizedVectorsFormatData", state.context.withRandomAccess());
                success = true;
            }
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this);
    }

    private void readFields(ChecksumIndexInput meta, int versionMeta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, versionMeta, info);
            Lucene99ScalarQuantizedVectorsReader.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    static void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long quantizedVectorBytes = fieldEntry.bits <= 4 && fieldEntry.compress ? (long)((dimension + 1 >> 1) + 4) : (long)(dimension + 4);
        long numQuantizedVectorBytes = Math.multiplyExact(quantizedVectorBytes, fieldEntry.size);
        if (numQuantizedVectorBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Quantized vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size + " * (dim=" + dimension + " + 4) = " + numQuantizedVectorBytes);
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        this.rawVectorsReader.checkIntegrity();
        CodecUtil.checksumEntireFile(this.quantizedVectorData);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        if (fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            throw new IllegalArgumentException("field=\"" + field + "\" is encoded as: " + fieldEntry.vectorEncoding + " expected: " + VectorEncoding.FLOAT32);
        }
        FloatVectorValues rawVectorValues = this.rawVectorsReader.getFloatVectorValues(field);
        OffHeapQuantizedByteVectorValues quantizedByteVectorValues = OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        return new QuantizedVectorValues(rawVectorValues, quantizedByteVectorValues);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        return this.rawVectorsReader.getByteVectorValues(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName, IOContext context2) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, context2);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 1, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        if (fieldEntry.scalarQuantizer == null) {
            return this.rawVectorsReader.getRandomVectorScorer(field, target);
        }
        OffHeapQuantizedByteVectorValues vectorValues = OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
        return this.vectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (RandomAccessVectorValues)vectorValues, target);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
        return this.rawVectorsReader.getRandomVectorScorer(field, target);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.quantizedVectorData, this.rawVectorsReader);
    }

    @Override
    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
        return size += this.rawVectorsReader.ramBytesUsed();
    }

    private FieldEntry readField(IndexInput input, int versionMeta, FieldInfo info) throws IOException {
        VectorEncoding vectorEncoding = Lucene99HnswVectorsReader.readVectorEncoding(input);
        VectorSimilarityFunction similarityFunction = Lucene99HnswVectorsReader.readSimilarityFunction(input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + similarityFunction + " != " + info.getVectorSimilarityFunction());
        }
        return new FieldEntry(input, versionMeta, vectorEncoding, info.getVectorSimilarityFunction());
    }

    @Override
    public QuantizedByteVectorValues getQuantizedVectorValues(String fieldName) throws IOException {
        FieldEntry fieldEntry = this.fields.get(fieldName);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        return OffHeapQuantizedByteVectorValues.load(fieldEntry.ordToDoc, fieldEntry.dimension, fieldEntry.size, fieldEntry.scalarQuantizer, fieldEntry.similarityFunction, this.vectorScorer, fieldEntry.compress, fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength, this.quantizedVectorData);
    }

    @Override
    public ScalarQuantizer getQuantizationState(String fieldName) {
        FieldEntry fieldEntry = this.fields.get(fieldName);
        if (fieldEntry == null || fieldEntry.vectorEncoding != VectorEncoding.FLOAT32) {
            return null;
        }
        return fieldEntry.scalarQuantizer;
    }

    private static final class QuantizedVectorValues
    extends FloatVectorValues {
        private final FloatVectorValues rawVectorValues;
        private final OffHeapQuantizedByteVectorValues quantizedVectorValues;

        QuantizedVectorValues(FloatVectorValues rawVectorValues, OffHeapQuantizedByteVectorValues quantizedVectorValues) {
            this.rawVectorValues = rawVectorValues;
            this.quantizedVectorValues = quantizedVectorValues;
        }

        @Override
        public int dimension() {
            return this.rawVectorValues.dimension();
        }

        @Override
        public int size() {
            return this.rawVectorValues.size();
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.rawVectorValues.vectorValue();
        }

        @Override
        public int docID() {
            return this.rawVectorValues.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int rawDocId = this.rawVectorValues.nextDoc();
            int quantizedDocId = this.quantizedVectorValues.nextDoc();
            assert (rawDocId == quantizedDocId);
            return quantizedDocId;
        }

        @Override
        public int advance(int target) throws IOException {
            int rawDocId = this.rawVectorValues.advance(target);
            int quantizedDocId = this.quantizedVectorValues.advance(target);
            assert (rawDocId == quantizedDocId);
            return quantizedDocId;
        }

        @Override
        public VectorScorer scorer(float[] query2) throws IOException {
            return this.quantizedVectorValues.scorer(query2);
        }
    }

    private static class FieldEntry
    implements Accountable {
        private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class);
        final VectorSimilarityFunction similarityFunction;
        final VectorEncoding vectorEncoding;
        final int dimension;
        final long vectorDataOffset;
        final long vectorDataLength;
        final ScalarQuantizer scalarQuantizer;
        final int size;
        final byte bits;
        final boolean compress;
        final OrdToDocDISIReaderConfiguration ordToDoc;

        FieldEntry(IndexInput input, int versionMeta, VectorEncoding vectorEncoding, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorEncoding = vectorEncoding;
            this.vectorDataOffset = input.readVLong();
            this.vectorDataLength = input.readVLong();
            this.dimension = input.readVInt();
            this.size = input.readInt();
            if (this.size > 0) {
                if (versionMeta < 1) {
                    int floatBits = input.readInt();
                    if (floatBits == -1) {
                        throw new CorruptIndexException("Missing confidence interval for scalar quantizer", input);
                    }
                    float confidenceInterval = Float.intBitsToFloat(floatBits);
                    if (confidenceInterval == 0.0f) {
                        throw new CorruptIndexException("Invalid confidence interval for scalar quantizer: " + confidenceInterval, input);
                    }
                    this.bits = (byte)7;
                    this.compress = false;
                    float minQuantile = Float.intBitsToFloat(input.readInt());
                    float maxQuantile = Float.intBitsToFloat(input.readInt());
                    this.scalarQuantizer = new ScalarQuantizer(minQuantile, maxQuantile, 7);
                } else {
                    input.readInt();
                    this.bits = input.readByte();
                    this.compress = input.readByte() == 1;
                    float minQuantile = Float.intBitsToFloat(input.readInt());
                    float maxQuantile = Float.intBitsToFloat(input.readInt());
                    this.scalarQuantizer = new ScalarQuantizer(minQuantile, maxQuantile, this.bits);
                }
            } else {
                this.scalarQuantizer = null;
                this.bits = (byte)7;
                this.compress = false;
            }
            this.ordToDoc = OrdToDocDISIReaderConfiguration.fromStoredMeta(input, this.size);
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + RamUsageEstimator.sizeOf(this.ordToDoc);
        }
    }
}

