/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2;

import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.assembler.VocabTDB2;

public class TDB2Factory {
    private TDB2Factory() {
    }

    public static Dataset connectDataset(Location location) {
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(location);
        return DatasetFactory.wrap(dsg);
    }

    public static Dataset connectDataset(String location) {
        return TDB2Factory.connectDataset(Location.create(location));
    }

    public static Dataset createDataset() {
        return TDB2Factory.connectDataset(Location.mem());
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build(assemblerFile, VocabTDB2.tDatasetTDB);
    }

    public static boolean isTDB2(Dataset dataset) {
        return DatabaseMgr.isTDB2(dataset.asDatasetGraph());
    }

    public static Location location(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        return DatabaseMgr.location(dsg);
    }

    static {
        JenaSystem.init();
    }
}

