/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.OpBase;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public abstract class OpN
extends OpBase {
    private List<Op> elements = new ArrayList<Op>();

    protected OpN() {
        this.elements = new ArrayList<Op>();
    }

    protected OpN(List<Op> x) {
        this.elements = x;
    }

    public void add(Op op) {
        this.elements.add(op);
    }

    public Op get(int idx) {
        return this.elements.get(idx);
    }

    public abstract Op apply(Transform var1, List<Op> var2);

    public abstract OpN copy(List<Op> var1);

    protected boolean equalsSubOps(OpN op, NodeIsomorphismMap labelMap) {
        if (this.elements.size() != op.elements.size()) {
            return false;
        }
        ListIterator<Op> iter1 = this.elements.listIterator();
        ListIterator<Op> iter2 = op.elements.listIterator();
        while (iter1.hasNext()) {
            Op op2;
            Op op1 = (Op)iter1.next();
            if (op1.equalTo(op2 = (Op)iter2.next(), labelMap)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    public List<Op> getElements() {
        return this.elements;
    }

    public Iterator<Op> iterator() {
        return this.elements.iterator();
    }
}

