/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation.event;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.shacl.engine.constraint.DatatypeConstraint;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedEvent;
import org.apache.jena.shacl.validation.event.ConstraintEvaluationEvent;
import org.apache.jena.shacl.validation.event.EventUtil;
import org.apache.jena.shacl.validation.event.FocusNodeValidationEvent;
import org.apache.jena.shacl.validation.event.ShapeValidationEvent;
import org.apache.jena.shacl.validation.event.ValidationEvent;

public abstract class EventPredicates {
    public static Predicate<ValidationEvent> isOfType(Class<? extends ValidationEvent> type) {
        return e2 -> type.equals(e2.getClass());
    }

    public static Predicate<ValidationEvent> isOfTypeOrSubtype(Class<? extends ValidationEvent> type) {
        return e2 -> EventUtil.getSuperclassesAndInterfaces(e2.getClass()).anyMatch(s -> s.equals(type));
    }

    public static <E extends ValidationEvent> Predicate<ValidationEvent> testIfType(Class<E> type, Predicate<E> predicate, boolean defaultValue) {
        return e2 -> EventPredicates.testIfType(e2, type, predicate, defaultValue);
    }

    public static <E extends ValidationEvent> Predicate<ValidationEvent> testIfTypeElseFalse(Class<E> type, Predicate<E> predicate) {
        return e2 -> EventPredicates.testIfType(e2, type, predicate, false);
    }

    private static <E extends ValidationEvent> boolean testIfType(ValidationEvent e2, Class<E> type, Predicate<E> predicate, boolean defaultValue) {
        if (type.isAssignableFrom(e2.getClass())) {
            return predicate.test((ValidationEvent)type.cast(e2));
        }
        return defaultValue;
    }

    public static NodePredicate<ShapeValidationEvent> shapeNode() {
        return new NodePredicate<ShapeValidationEvent>(ShapeValidationEvent.class, e2 -> e2.getShape().getShapeNode());
    }

    public static NodePredicate<FocusNodeValidationEvent> focusNode() {
        return new NodePredicate<FocusNodeValidationEvent>(FocusNodeValidationEvent.class, FocusNodeValidationEvent::getFocusNode);
    }

    public static Predicate<ValidationEvent> hasConstraintOfType(Class<? extends Constraint> constraintType) {
        Objects.requireNonNull(constraintType);
        return EventPredicates.testIfType(ConstraintEvaluationEvent.class, e2 -> constraintType.isAssignableFrom(e2.getConstraint().getClass()), false);
    }

    public static Predicate<ValidationEvent> hasDatatypeConstraint() {
        return EventPredicates.hasConstraintOfType(DatatypeConstraint.class);
    }

    public static Predicate<ValidationEvent> isValid() {
        return EventPredicates.testIfTypeElseFalse(ConstraintEvaluatedEvent.class, ConstraintEvaluatedEvent::isValid);
    }

    public static class NodePredicate<E extends ValidationEvent> {
        private final Function<ValidationEvent, Node> nodeAccessor = e2 -> type.isAssignableFrom(e2.getClass()) ? (Node)nodeAccessor.apply(e2) : null;

        public NodePredicate(Class<E> type, Function<E, Node> nodeAccessor) {
        }

        public Predicate<ValidationEvent> makePredicate(Predicate<Node> predicate) {
            return e2 -> Optional.ofNullable(this.nodeAccessor.apply((ValidationEvent)e2)).map(predicate::test).orElse(false);
        }

        public Predicate<ValidationEvent> isBlank() {
            return this.makePredicate(Node::isBlank);
        }

        public Predicate<ValidationEvent> isLiteral() {
            return this.makePredicate(Node::isLiteral);
        }

        public Predicate<ValidationEvent> uriEquals(String uri) {
            return this.makePredicate(n -> n.isURI() && n.getURI().equals(uri));
        }

        public Predicate<ValidationEvent> literalEquals(LiteralLabel literalLabel) {
            return this.makePredicate(n -> n.isLiteral() && n.getLiteral().sameValueAs(literalLabel));
        }
    }
}

