/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.sparql.core.Quad;

public class PrefixLib {
    public static String canonicalPrefix(String prefix) {
        if (prefix == null) {
            return "";
        }
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static Node canonicalGraphName(Node graphName) {
        if (graphName == null || Quad.isDefaultGraph(graphName)) {
            return Prefixes.nodeDataset;
        }
        return graphName;
    }

    public static String abbreviate(PrefixMap prefixes, String uriStr) {
        Map<String, String> map = prefixes.getMapping();
        for (Map.Entry<String, String> e2 : map.entrySet()) {
            String ln2;
            String prefix = e2.getKey();
            String uriForPrefix = e2.getValue();
            if (!uriStr.startsWith(uriForPrefix) || !PrefixLib.strSafeFor(ln2 = uriStr.substring(uriForPrefix.length()), '/') || !PrefixLib.strSafeFor(ln2, '#') || !PrefixLib.strSafeFor(ln2, ':')) continue;
            return prefix + ":" + ln2;
        }
        return null;
    }

    public static Pair<String, String> abbrev(PrefixMap prefixes, String uriStr) {
        return PrefixLib.abbrev(prefixes.getMapping(), uriStr, true);
    }

    public static Pair<String, String> abbrev(Map<String, String> prefixesMap, String uriStr, boolean turtleSafeLocalPart) {
        for (Map.Entry<String, String> e2 : prefixesMap.entrySet()) {
            String prefix = e2.getKey();
            String uriForPrefix = e2.getValue();
            if (!uriStr.startsWith(uriForPrefix)) continue;
            String ln2 = uriStr.substring(uriForPrefix.length());
            if (turtleSafeLocalPart && !PrefixLib.isSafeLocalPart(ln2)) continue;
            return Pair.create(e2.getKey(), ln2);
        }
        return null;
    }

    public static String expand(PrefixMap prefixes, String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            return null;
        }
        return PrefixLib.expand(prefixes, prefixedName.substring(0, i), prefixedName.substring(i + 1));
    }

    public static String expand(PrefixMap prefixes, String prefix, String localName) {
        String x = prefixes.get(prefix = PrefixLib.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x + localName;
    }

    protected static String getPossibleKey(String iriString) {
        int index = iriString.lastIndexOf(35);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        index = iriString.lastIndexOf(47);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        return null;
    }

    public static boolean isSafeLocalPart(String localName) {
        return PrefixLib.strSafeFor(localName, '/') && PrefixLib.strSafeFor(localName, '#');
    }

    private static boolean strSafeFor(String str2, char ch) {
        return str2.indexOf(ch) == -1;
    }
}

