/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import org.apache.jena.rfc3986.ErrorHandler;
import org.apache.jena.rfc3986.IRI3986;
import org.apache.jena.rfc3986.IRIParseException;
import org.apache.jena.rfc3986.Severity;
import org.apache.jena.rfc3986.SeverityMap;
import org.apache.jena.rfc3986.Violations;

public class SystemIRI3986 {
    private static final ErrorHandler errorHandlerSystemDefault;
    private static ErrorHandler errorHandler;

    public static void setErrorHandler(ErrorHandler errHandler) {
        errorHandler = errHandler;
    }

    public static ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    public static void toHandler(IRI3986 iri2, ErrorHandler errorHandler) {
        SystemIRI3986.toHandler(iri2, Violations.severities(), errorHandler);
    }

    public static void toHandler(IRI3986 iri2, SeverityMap severityMap, ErrorHandler errorHandler) {
        iri2.forEachViolation(report -> {
            Severity severity = severityMap.getOrDefault(report.issue(), Severity.INVALID);
            switch (severity) {
                case WARNING: {
                    errorHandler.warning(report.message());
                    break;
                }
                case ERROR: 
                case INVALID: {
                    errorHandler.error(report.message());
                    break;
                }
            }
        });
    }

    static String formatMsg(CharSequence source, int posn, String s) {
        StringBuilder sb = new StringBuilder(s.length() + 20);
        if (source != null) {
            sb.append("<");
            sb.append(source);
            sb.append("> : ");
        }
        if (posn >= 0) {
            sb.append("[Posn " + posn + "] ");
        }
        sb.append(s);
        return sb.toString();
    }

    static {
        errorHandler = errorHandlerSystemDefault = ErrorHandler.create(s -> {
            throw new IRIParseException((String)s);
        }, null);
    }
}

