/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.ResultSetAdapter;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetAdapter;

public interface ResultSet
extends Iterator<QuerySolution> {
    public static ResultSet adapt(RowSet rowSet) {
        if (rowSet instanceof RowSetAdapter) {
            return ((RowSetAdapter)rowSet).get();
        }
        return new ResultSetAdapter(rowSet);
    }

    @Override
    public boolean hasNext();

    @Override
    public QuerySolution next();

    @Override
    public void forEachRemaining(Consumer<? super QuerySolution> var1);

    public QuerySolution nextSolution();

    public Binding nextBinding();

    public int getRowNumber();

    public List<String> getResultVars();

    public Model getResourceModel();

    default public ResultSetRewindable rewindable() {
        return ResultSetFactory.makeRewindable(this);
    }

    default public ResultSet materialise() {
        return this.rewindable();
    }

    public void close();
}

