/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.implementation.registry;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.geosparql.implementation.SRSInfo;
import org.apache.jena.geosparql.implementation.SRSInfoException;
import org.apache.jena.geosparql.implementation.UnitsOfMeasure;
import org.apache.jena.geosparql.implementation.registry.UnitsRegistry;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRSRegistry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Map<String, SRSInfo> SRS_REGISTRY = Collections.synchronizedMap(new HashMap());
    private static final String NORTH_UTM_EPSG = "http://www.opengis.net/def/crs/EPSG/0/326";
    private static final String SOUTH_UTM_EPSG = "http://www.opengis.net/def/crs/EPSG/0/327";
    private static final DecimalFormat ZONE_FORMATTER = new DecimalFormat("##");

    public static final UnitsOfMeasure getUnitsOfMeasure(String srsURI) {
        SRSInfo srsInfo = SRSRegistry.storeSRS(srsURI);
        return srsInfo.getUnitsOfMeasure();
    }

    public static final Boolean getAxisXY(String srsURI) {
        SRSInfo srsInfo = SRSRegistry.storeSRS(srsURI);
        return srsInfo.isAxisXY();
    }

    public static final CoordinateReferenceSystem getCRS(String srsURI) {
        SRSInfo srsInfo = SRSRegistry.storeSRS(srsURI);
        return srsInfo.getCrs();
    }

    public static final SRSInfo getSRSInfo(String srsURI) {
        return SRSRegistry.storeSRS(srsURI);
    }

    private static SRSInfo storeSRS(String srsURI) {
        SRSInfo srsInfo;
        if (SRS_REGISTRY.containsKey(srsURI)) {
            srsInfo = SRS_REGISTRY.get(srsURI);
        } else {
            try {
                srsInfo = new SRSInfo(srsURI);
            }
            catch (SRSInfoException ex) {
                LOGGER.warn("SRS URI not recognised so operation results may not be correct or accurate: {} - {}", (Object)srsURI, (Object)ex.getMessage());
                srsInfo = SRSInfo.getUnrecognised(srsURI);
            }
            SRS_REGISTRY.put(srsURI, srsInfo);
        }
        return srsInfo;
    }

    public static final void setupDefaultSRS() {
        SRSInfo srsInfo = SRSInfo.getDefaultWktCRS84("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        SRS_REGISTRY.put("http://www.opengis.net/def/crs/OGC/1.3/CRS84", srsInfo);
        SRS_REGISTRY.put("http://www.opengis.net/def/crs/EPSG/4326", SRSInfo.getDefaultWktCRS84("http://www.opengis.net/def/crs/EPSG/4326"));
        UnitsRegistry.addUnit(srsInfo.getUnitsOfMeasure());
    }

    public static final void reset() {
        SRS_REGISTRY.clear();
        SRSRegistry.setupDefaultSRS();
    }

    public static final String findUTMZoneURIFromWGS84(double latitude, double longitude) {
        int zone = (int)Math.floor(longitude / 6.0 + 31.0);
        String zoneString = ZONE_FORMATTER.format(zone);
        boolean isNorth = latitude >= 0.0;
        String epsgURI = isNorth ? NORTH_UTM_EPSG + zoneString : SOUTH_UTM_EPSG + zoneString;
        return epsgURI;
    }
}

