/*
 * Decompiled with CFR 0.152.
 */
package jena;

import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sys.JenaSystem;

public class rdfcompare {
    public static void main(String ... args) {
        if (args.length < 2 || args.length > 6) {
            rdfcompare.usage();
            System.exit(-1);
        }
        String in1 = args[0];
        String in2 = args[1];
        String lang1 = null;
        if (args.length >= 3) {
            lang1 = args[2];
        }
        String lang2 = null;
        if (args.length >= 4) {
            lang2 = args[3];
        }
        String base1 = null;
        if (args.length >= 5) {
            base1 = args[4];
        }
        String base2 = base1;
        if (args.length >= 6) {
            base2 = args[5];
        }
        try {
            Model m1 = ModelFactory.createDefaultModel();
            Model m2 = ModelFactory.createDefaultModel();
            rdfcompare.read(m1, in1, lang1, base1);
            rdfcompare.read(m2, in2, lang2, base2);
            if (m1.isIsomorphicWith(m2)) {
                System.out.println("models are equal");
                System.out.println();
                System.exit(0);
            } else {
                System.out.println("models are unequal");
                System.out.println();
                System.exit(1);
            }
        }
        catch (Exception e2) {
            System.err.println("Unhandled exception:");
            System.err.println("    " + e2.toString());
            System.exit(-1);
        }
    }

    protected static void usage() {
        System.err.println("usage:");
        System.err.println("    java jena.rdfcompare source1 source2 [lang1 [lang2 [base1 [base2]]]]");
        System.err.println();
        System.err.println("    source1 and source2 can be URL's or filenames");
        System.err.println("    lang1 and lang2 can take values:");
        System.err.println("      RDF/XML, N-TRIPLE, TURTLE, JSON-LD");
        System.err.println("    base1 and base2 are URIs");
        System.err.println("    base1 defaults to null");
        System.err.println("    base2 defaults to base1");
        System.err.println("If no base URIs are specified Jena determines the base URI based on the input source");
        System.err.println();
    }

    protected static void read(Model model, String in, String langStr, String base) {
        Lang lang = null;
        if (langStr != null) {
            lang = RDFLanguages.nameToLang(langStr);
        }
        RDFDataMgr.read(model, in, base, lang);
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
    }
}

