/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.observation;

import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class ObservationTextPublisher
implements ObservationHandler<Observation.Context> {
    private final Consumer<String> consumer;
    private final Predicate<Observation.Context> supportsContextPredicate;
    private final Function<Observation.Context, String> converter;

    public ObservationTextPublisher() {
        this(InternalLoggerFactory.getInstance(ObservationTextPublisher.class)::info, context2 -> true, String::valueOf);
    }

    public ObservationTextPublisher(Consumer<String> consumer) {
        this(consumer, context2 -> true, String::valueOf);
    }

    public ObservationTextPublisher(Consumer<String> consumer, Predicate<Observation.Context> supportsContextPredicate) {
        this(consumer, supportsContextPredicate, String::valueOf);
    }

    public ObservationTextPublisher(Consumer<String> consumer, Predicate<Observation.Context> supportsContextPredicate, Function<Observation.Context, String> converter) {
        this.consumer = consumer;
        this.supportsContextPredicate = supportsContextPredicate;
        this.converter = converter;
    }

    @Override
    public void onStart(Observation.Context context2) {
        this.publish("START", context2);
    }

    @Override
    public void onError(Observation.Context context2) {
        this.publish("ERROR", context2);
    }

    @Override
    public void onEvent(Observation.Event event, Observation.Context context2) {
        this.publishUnformatted(String.format("%5s - %s, %s", "EVENT", event, this.converter.apply(context2)));
    }

    @Override
    public void onScopeOpened(Observation.Context context2) {
        this.publish("OPEN", context2);
    }

    @Override
    public void onScopeClosed(Observation.Context context2) {
        this.publish("CLOSE", context2);
    }

    @Override
    public void onStop(Observation.Context context2) {
        this.publish("STOP", context2);
    }

    @Override
    public boolean supportsContext(Observation.Context context2) {
        return this.supportsContextPredicate.test(context2);
    }

    private void publish(String event, Observation.Context context2) {
        this.publishUnformatted(String.format("%5s - %s", event, this.converter.apply(context2)));
    }

    private void publishUnformatted(String event) {
        this.consumer.accept(event);
    }
}

