/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntID;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;

public class OntIDImpl
extends OntObjectImpl
implements OntID {
    public OntIDImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    @Override
    public String getVersionIRI() {
        Set res = Iterators.takeAsSet(this.listProperties(OWL2.versionIRI).mapWith(Statement::getObject).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource).mapWith(Resource::getURI), 2);
        return res.size() == 1 ? (String)res.iterator().next() : null;
    }

    @Override
    public OntIDImpl setVersionIRI(String uri) throws OntJenaException {
        if (uri != null && this.isAnon()) {
            throw new OntJenaException.IllegalArgument("Attempt to add version IRI (" + uri + ") to anonymous ontology (" + this.asNode().toString() + ").");
        }
        this.removeAll(OWL2.versionIRI);
        if (uri != null) {
            this.addProperty(OWL2.versionIRI, (RDFNode)this.getModel().createResource(uri));
        }
        return this;
    }

    @Override
    public OntIDImpl addImport(String uri) throws OntJenaException {
        if (OntJenaException.notNull(uri, "Null uri specified.").equals(this.getURI())) {
            throw new OntJenaException.IllegalArgument("Can't import itself: " + uri);
        }
        this.addImportResource(this.getModel().createResource(uri));
        return this;
    }

    @Override
    public OntIDImpl removeImport(String uri) {
        Resource r = this.getModel().createResource(OntJenaException.notNull(uri, "Null uri specified."));
        this.removeImportResource(r);
        return this;
    }

    @Override
    public Stream<String> imports() {
        return Iterators.asStream(this.listImportResources().mapWith(Resource::getURI), this.getCharacteristics());
    }

    public ExtendedIterator<Resource> listImportResources() {
        return this.listObjects(OWL2.imports).filterKeep(RDFNode::isURIResource).mapWith(RDFNode::asResource);
    }

    public void addImportResource(Resource uri) {
        this.addProperty(OWL2.imports, (RDFNode)uri);
    }

    public void removeImportResource(Resource uri) {
        this.getModel().remove(this, OWL2.imports, (RDFNode)uri);
    }

    @Override
    public String toString() {
        String iri = this.asNode().toString();
        String ver = this.getVersionIRI();
        if (ver != null) {
            return iri + "(" + ver + ")";
        }
        return iri;
    }
}

