/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;

public abstract class OntDisjointImpl<O extends OntObject>
extends OntObjectImpl
implements OntDisjoint<O> {
    public OntDisjointImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntDisjoint.Classes createDisjointClasses(OntGraphModelImpl model, Stream<OntClass> classes) {
        return OntDisjointImpl.create(model, OWL2.AllDisjointClasses, OntDisjoint.Classes.class, OntClass.class, classes, OWL2.members);
    }

    public static OntDisjoint.Individuals createDifferentIndividuals(OntGraphModelImpl model, Stream<OntIndividual> individuals) {
        Property membersPredicate = OntGraphModelImpl.configValue(model, OntModelControls.USE_OWL1_DISTINCT_MEMBERS_PREDICATE_FEATURE) ? OWL2.distinctMembers : OWL2.members;
        return OntDisjointImpl.create(model, OWL2.AllDifferent, OntDisjoint.Individuals.class, OntIndividual.class, individuals, membersPredicate);
    }

    public static OntDisjoint.ObjectProperties createDisjointObjectProperties(OntGraphModelImpl model, Stream<OntObjectProperty> properties) {
        return OntDisjointImpl.create(model, OWL2.AllDisjointProperties, OntDisjoint.ObjectProperties.class, OntObjectProperty.class, properties, OWL2.members);
    }

    public static OntDisjoint.DataProperties createDisjointDataProperties(OntGraphModelImpl model, Stream<OntDataProperty> properties) {
        return OntDisjointImpl.create(model, OWL2.AllDisjointProperties, OntDisjoint.DataProperties.class, OntDataProperty.class, properties, OWL2.members);
    }

    public static <R extends OntDisjoint<?>, E extends OntObject> R create(OntGraphModelImpl model, Resource type, Class<R> resultType, Class<E> memberType, Stream<E> members, Property membersPredicate) {
        OntJenaException.notNull(members, "Null " + OntEnhNodeFactories.viewAsString(memberType) + " members stream.");
        RDFList items = model.createList(members.peek(x -> OntJenaException.notNull(x, "OntDisjoint: Null " + OntEnhNodeFactories.viewAsString(memberType) + " is specified")).iterator());
        Resource res = model.createResource().addProperty(RDF.type, (RDFNode)type).addProperty(membersPredicate, (RDFNode)items);
        return (R)((OntDisjoint)model.getNodeAs(res.asNode(), resultType));
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntDisjointImpl.getRequiredRootStatement(this, this.getResourceType());
    }

    protected Property getPredicate() {
        return OWL2.members;
    }

    protected abstract Class<O> getComponentType();

    protected abstract Resource getResourceType();

    @Override
    public Stream<O> members() {
        return Iterators.asStream(this.listMembers());
    }

    public ExtendedIterator<O> listMembers() {
        return ((OntListImpl)this.getList()).listMembers();
    }

    @Override
    public OntListImpl<O> getList() {
        return this.getModel().asOntList(this.getRequiredObject(this.getPredicate(), RDFList.class), this, this.getPredicate(), this.getComponentType());
    }

    @Override
    public ExtendedIterator<OntStatement> listSpec() {
        return Iterators.concat(super.listSpec(), ((OntListImpl)this.getList()).listContent());
    }

    public static class DataPropertiesImpl
    extends PropertiesImpl<OntDataProperty>
    implements OntDisjoint.DataProperties {
        public DataPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDisjoint.DataProperties.class;
        }

        @Override
        protected Class<OntDataProperty> getComponentType() {
            return OntDataProperty.class;
        }
    }

    public static class ObjectPropertiesImpl
    extends PropertiesImpl<OntObjectProperty>
    implements OntDisjoint.ObjectProperties {
        public ObjectPropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDisjoint.ObjectProperties.class;
        }

        @Override
        protected Class<OntObjectProperty> getComponentType() {
            return OntObjectProperty.class;
        }
    }

    public static abstract class PropertiesImpl<P extends OntRelationalProperty>
    extends OntDisjointImpl<P>
    implements OntDisjoint.Properties<P> {
        public PropertiesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        protected Resource getResourceType() {
            return OWL2.AllDisjointProperties;
        }
    }

    public static class IndividualsImpl
    extends OntDisjointImpl<OntIndividual>
    implements OntDisjoint.Individuals {
        private final boolean useMembers;
        private final boolean useDistinctMembers;

        public IndividualsImpl(Node n, EnhGraph m, boolean useMembers, boolean useDistinctMembers) {
            super(n, m);
            this.useMembers = useMembers;
            this.useDistinctMembers = useDistinctMembers;
        }

        @Override
        public ExtendedIterator<OntIndividual> listMembers() {
            return Iterators.flatMap(this.lists(), OntListImpl::listMembers);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), Iterators.flatMap(this.lists(), OntListImpl::listContent));
        }

        public ExtendedIterator<Property> listPredicates() {
            if (this.useDistinctMembers) {
                return Iterators.of(this.getAlternativePredicate());
            }
            if (this.useMembers) {
                return Iterators.of(this.getPredicate());
            }
            return Iterators.of(new Property[]{this.getPredicate(), this.getAlternativePredicate()});
        }

        public ExtendedIterator<OntListImpl<OntIndividual>> lists() {
            return this.listPredicates().mapWith(this::findList).filterKeep(Optional::isPresent).mapWith(Optional::get);
        }

        @Override
        public OntListImpl<OntIndividual> getList() {
            if (this.useDistinctMembers) {
                return this.findList(this.getAlternativePredicate()).orElseThrow(() -> new OntJenaException.IllegalState("Can't find owl:distinctMembers"));
            }
            if (this.useMembers) {
                return this.findList(this.getPredicate()).orElseThrow(() -> new OntJenaException.IllegalState("Can't find owl:members"));
            }
            Optional<OntListImpl<OntIndividual>> p = this.findList(this.getPredicate());
            Optional<OntListImpl<OntIndividual>> a = this.findList(this.getAlternativePredicate());
            if (p.isPresent() && a.isPresent()) {
                return p.get();
            }
            if (p.isPresent()) {
                return p.get();
            }
            if (a.isPresent()) {
                return a.get();
            }
            throw new OntJenaException.IllegalState("Can't find owl:members or owl:distinctMembers");
        }

        public Optional<OntListImpl<OntIndividual>> findList(Property predicate) {
            if (!this.hasProperty(predicate)) {
                return Optional.empty();
            }
            return Optional.of(this.getModel().asOntList(this.getRequiredObject(predicate, RDFList.class), this, predicate, this.getComponentType()));
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDisjoint.Individuals.class;
        }

        protected Property getAlternativePredicate() {
            return OWL2.distinctMembers;
        }

        @Override
        protected Class<OntIndividual> getComponentType() {
            return OntIndividual.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL2.AllDifferent;
        }
    }

    public static class QLRLClassesImpl
    extends OntDisjointImpl<OntClass>
    implements OntDisjoint.Classes {
        public QLRLClassesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDisjoint.Classes.class;
        }

        @Override
        protected Class<OntClass> getComponentType() {
            return OntClass.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL2.AllDisjointClasses;
        }

        @Override
        public Stream<OntClass> members() {
            return ((OntListImpl)this.getList()).members().filter(OntClass::canAsDisjointClass).map(OntClass::asDisjointClass);
        }
    }

    public static class ClassesImpl
    extends OntDisjointImpl<OntClass>
    implements OntDisjoint.Classes {
        public ClassesImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> objectType() {
            return OntDisjoint.Classes.class;
        }

        @Override
        protected Class<OntClass> getComponentType() {
            return OntClass.class;
        }

        @Override
        protected Resource getResourceType() {
            return OWL2.AllDisjointClasses;
        }
    }
}

