/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.single;

import java.util.List;
import org.apache.jena.query.QueryException;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.service.single.ServiceExecutor;

public class ServiceExecutorOverRegistry
implements ServiceExecutor {
    protected ServiceExecutorRegistry registry;
    protected int pos;

    public ServiceExecutorOverRegistry(ServiceExecutorRegistry registry) {
        this(registry, 0);
    }

    public ServiceExecutorOverRegistry(ServiceExecutorRegistry registry, int pos) {
        this.registry = registry;
        this.pos = pos;
    }

    @Override
    public QueryIterator createExecution(OpService opExecute, OpService original, Binding binding, ExecutionContext execCxt) {
        List<ChainingServiceExecutor> factories = this.registry.getSingleChain();
        int n = factories.size();
        if (this.pos >= n) {
            if (opExecute.getSilent()) {
                return QueryIterRoot.create(execCxt);
            }
            throw new QueryException("No more elements in service executor chain (pos=" + this.pos + ", chain size=" + n + ")");
        }
        ChainingServiceExecutor factory = factories.get(this.pos);
        ServiceExecutorOverRegistry next = new ServiceExecutorOverRegistry(this.registry, this.pos + 1);
        QueryIterator result = factory.createExecution(opExecute, original, binding, execCxt, next);
        return result;
    }
}

