/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetRewindable;

public class RowSetMem
implements RowSetRewindable {
    protected final List<Binding> rows;
    protected final List<Var> vars;
    private int rowNumber = 0;
    private PeekIterator<Binding> iterator = null;

    public static RowSetRewindable create(RowSet rowSet) {
        if (rowSet instanceof RowSetMem) {
            return new RowSetMem((RowSetMem)rowSet);
        }
        return new RowSetMem(rowSet);
    }

    private RowSetMem(RowSetMem other) {
        this.vars = other.vars;
        this.rows = other.rows;
        this.reset();
    }

    private RowSetMem(RowSet other) {
        if (other instanceof RowSetMem) {
            RowSetMem rsm = (RowSetMem)other;
            this.rows = rsm.rows;
            this.vars = rsm.getResultVars();
            return;
        }
        ArrayList<Binding> arr = new ArrayList<Binding>();
        other.forEachRemaining(arr::add);
        this.rows = arr;
        this.vars = other.getResultVars();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Binding next() {
        ++this.rowNumber;
        return (Binding)this.iterator.next();
    }

    public void rewind() {
        this.reset();
    }

    @Override
    public void reset() {
        this.iterator = new PeekIterator(this.rows.iterator());
        this.rowNumber = 0;
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    @Override
    public List<Var> getResultVars() {
        return this.vars;
    }

    public Binding peek() {
        return (Binding)this.iterator.element();
    }

    @Override
    public void close() {
    }
}

