/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.CDTAwareParserProfile;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.FactoryRDFCaching;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.riot.writer.DirectiveStyle;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.util.iterator.ExtendedIterator;

public class RiotLib {
    private static final boolean skolomizedBNodes = ARQ.isTrueOrUndef(ARQ.constantBNodeLabels);
    private static final String bNodeLabelStart = "_:";
    private static final String URI_PREFIX_FIXUP = "local:";
    public static final Function<String, String> fixupPrefixes = "local:"::concat;
    public static final Predicate<String> testFixupedPrefixURI = x -> x.startsWith(URI_PREFIX_FIXUP);

    public static Node blankNodeToIri(Node node) {
        if (node.isBlank()) {
            return NodeFactory.createURI((String)RiotLib.blankNodeToIriString(node));
        }
        return node;
    }

    public static String blankNodeToIriString(Node node) {
        if (node.isBlank()) {
            String x = node.getBlankNodeLabel();
            return bNodeLabelStart + x;
        }
        if (node.isURI()) {
            return node.getURI();
        }
        throw new RiotException("Not a blank node or URI");
    }

    public static Node fromIRIorBNode(Node node) {
        if (!node.isURI()) {
            return node;
        }
        String uristr = node.getURI();
        return RiotLib.createIRIorBNode(uristr);
    }

    public static Node createIRIorBNode(String str2) {
        if (skolomizedBNodes && RiotLib.isBNodeIRI(str2)) {
            String s = str2.substring(bNodeLabelStart.length());
            return NodeFactory.createBlankNode((String)s);
        }
        return NodeFactory.createURI((String)str2);
    }

    public static boolean isBNodeIRI(String iri) {
        return iri.startsWith(bNodeLabelStart);
    }

    public static boolean isBNodeIRI(Node node) {
        if (!node.isURI()) {
            return false;
        }
        return RiotLib.isBNodeIRI(node.getURI());
    }

    public static boolean isPrefixIRI(String iri) {
        return testFixupedPrefixURI.test(iri);
    }

    public static String fixupPrefixIRI(String prefix, String localPart) {
        return RiotLib.fixupPrefixIRI(prefix + ":" + localPart);
    }

    public static String fixupPrefixIRI(String prefixedName) {
        return fixupPrefixes.apply(prefixedName);
    }

    public static Node parse(String string) {
        return NodeFactoryExtra.parseNode(string, null);
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            boolean checking = SysRIOT.isStrictMode();
            return RiotLib.profile(baseIRI, false, checking, handler);
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            return RiotLib.profile(baseIRI, false, true, handler);
        }
        return RiotLib.profile(baseIRI, true, true, handler);
    }

    private static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        LabelToNode labelToNode = SyntaxLabels.createLabelToNode();
        IRIx base = resolveIRIs ? IRIs.resolveIRI((String)baseIRI) : IRIx.create((String)baseIRI);
        IRIxResolver resolver = IRIxResolver.create((IRIx)base).resolve(resolveIRIs).allowRelative(false).build();
        return RiotLib.createParserProfile(RiotLib.factoryRDF(labelToNode), handler, resolver, checking);
    }

    public static FactoryRDF factoryRDF(LabelToNode labelMapping) {
        return new FactoryRDFCaching(5000, labelMapping);
    }

    public static FactoryRDF factoryRDF() {
        return RiotLib.factoryRDF(SyntaxLabels.createLabelToNode());
    }

    public static ParserProfile dftProfile() {
        return RiotLib.createParserProfile(RiotLib.factoryRDF(), ErrorHandlerFactory.errorHandlerStd, true);
    }

    public static ParserProfile createParserProfile(FactoryRDF factory, ErrorHandler errorHandler, boolean checking) {
        return new CDTAwareParserProfile(factory, errorHandler, IRIxResolver.create((IRIx)IRIs.getSystemBase()).build(), PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    public static ParserProfile createParserProfile(FactoryRDF factory, ErrorHandler errorHandler, IRIxResolver resolver, boolean checking) {
        return new CDTAwareParserProfile(factory, errorHandler, resolver, PrefixMapFactory.create(), RIOT.getContext().copy(), checking, false);
    }

    public static Collection<Triple> triplesOfSubject(Graph graph, Node subj) {
        return RiotLib.triples(graph, subj, Node.ANY, Node.ANY);
    }

    public static List<Triple> triples(Graph graph, Node s, Node p, Node o) {
        ArrayList<Triple> acc = new ArrayList<Triple>();
        RiotLib.accTriples(acc, graph, s, p, o);
        return acc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long countTriples(Graph graph, Node s, Node p, Node o) {
        try (ExtendedIterator iter = graph.find(s, p, o);){
            long l = Iter.count((Iterator)iter);
            return l;
        }
    }

    public static long countTriples(DatasetGraph dsg, Node s, Node p, Node o) {
        Iterator<Quad> iter = dsg.find(Node.ANY, s, p, o);
        return Iter.count(iter);
    }

    public static void accTriples(Collection<Triple> acc, Graph graph, Node s, Node p, Node o) {
        graph.find(s, p, o).forEach(acc::add);
    }

    public static void writeBase(IndentedWriter out, String base) {
        RiotLib.writeBase(out, base, DirectiveStyle.systemDefault);
    }

    public static void writeBase(IndentedWriter out, String base, DirectiveStyle writeStyle) {
        if (writeStyle == DirectiveStyle.AT) {
            RiotLib.writeBaseOldStyle(out, base);
        } else {
            RiotLib.writeBaseNewStyle(out, base);
        }
    }

    private static void writeBaseNewStyle(IndentedWriter out, String base) {
        if (base != null) {
            out.print("BASE ");
            out.pad(7);
            out.print("<");
            out.print(base);
            out.print(">");
            out.println();
        }
    }

    private static void writeBaseOldStyle(IndentedWriter out, String base) {
        if (base != null) {
            out.print("@base ");
            out.pad(8);
            out.print("<");
            out.print(base);
            out.print(">");
            out.print(" .");
            out.println();
        }
    }

    public static void writePrefixes(IndentedWriter out, PrefixMap prefixMap) {
        RiotLib.writePrefixes(out, prefixMap, DirectiveStyle.systemDefault);
    }

    public static void writePrefixes(IndentedWriter out, PrefixMap prefixMap, DirectiveStyle writeStyle) {
        if (prefixMap != null && !prefixMap.isEmpty()) {
            int maxPrefixLength = prefixMap.getMapping().keySet().stream().map(String::length).max(Comparator.naturalOrder()).orElse(0);
            for (Map.Entry<String, String> e2 : RiotLib.sortPrefixes(prefixMap)) {
                RiotLib.writePrefix(out, e2.getKey(), e2.getValue(), writeStyle, maxPrefixLength);
            }
        }
    }

    private static List<Map.Entry<String, String>> sortPrefixes(PrefixMap prefixMap) {
        ArrayList<Map.Entry<String, String>> prefixesMappings = new ArrayList<Map.Entry<String, String>>(prefixMap.getMapping().entrySet());
        prefixesMappings.sort(Map.Entry.comparingByKey());
        return prefixesMappings;
    }

    public static void writePrefix(IndentedWriter out, String prefix, String uri, DirectiveStyle writeStyle) {
        RiotLib.writePrefix(out, prefix, uri, writeStyle, 0);
    }

    private static void writePrefix(IndentedWriter out, String prefix, String uri, DirectiveStyle writeStyle, int maxPrefixLength) {
        if (writeStyle == DirectiveStyle.AT) {
            RiotLib.writePrefixOldStyle(out, prefix, uri, maxPrefixLength);
        } else {
            RiotLib.writePrefixNewStyle(out, prefix, uri, maxPrefixLength);
        }
    }

    private static void writePrefixNewStyle(IndentedWriter out, String prefix, String uri, int intent) {
        out.print("PREFIX ");
        out.print(prefix);
        out.print(": ");
        out.pad(9 + intent);
        out.print("<");
        out.print(uri);
        out.print(">");
        out.println();
    }

    private static void writePrefixOldStyle(IndentedWriter out, String prefix, String uri, int intent) {
        out.print("@prefix ");
        out.print(prefix);
        out.print(": ");
        out.pad(10 + intent);
        out.print("<");
        out.print(uri);
        out.print(">");
        out.print(" .");
        out.println();
    }

    public static void writeVersion(IndentedWriter out, String version2, DirectiveStyle writeStyle) {
        if (writeStyle == DirectiveStyle.AT) {
            RiotLib.writeVersionOldStyle(out, version2);
        } else {
            RiotLib.writeVersionNewStyle(out, version2);
        }
    }

    private static void writeVersionNewStyle(IndentedWriter out, String version2) {
        char chQuote = '\"';
        String escVersion = EscapeStr.stringEsc((String)version2, (char)'\"');
        out.print("VERSION ");
        out.print(chQuote);
        out.print(escVersion);
        out.print(chQuote);
        out.println();
    }

    private static void writeVersionOldStyle(IndentedWriter out, String version2) {
        char chQuote = '\"';
        String escVersion = EscapeStr.stringEsc((String)version2, (char)'\"');
        out.print("@version ");
        out.print(chQuote);
        out.print(escVersion);
        out.print(chQuote);
        out.print(" .");
        out.println();
    }

    public static IndentedWriter create(Writer writer) {
        return new IndentedWriterWriter(writer);
    }

    public static WriterGraphRIOTBase adapter(WriterDatasetRIOT writer) {
        return new WriterAdapter(writer);
    }

    private static class IndentedWriterWriter
    extends IndentedWriter {
        IndentedWriterWriter(Writer w) {
            super(w);
        }
    }

    private static class WriterAdapter
    extends WriterGraphRIOTBase {
        private WriterDatasetRIOT writer;

        WriterAdapter(WriterDatasetRIOT writer) {
            this.writer = writer;
        }

        @Override
        public Lang getLang() {
            return this.writer.getLang();
        }

        @Override
        public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
            this.writer.write(out, DatasetGraphFactory.wrap(graph), prefixMap, baseURI, context2);
        }

        @Override
        public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
            this.writer.write(out, DatasetGraphFactory.wrap(graph), prefixMap, baseURI, context2);
        }
    }
}

