/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFVisitor;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StatementTerm;
import org.apache.jena.rdf.model.StmtTermRequiredException;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.StatementImpl;

public class StatementTermImpl
extends EnhNode
implements StatementTerm {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return !n.isLiteral();
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isLiteral()) {
                throw new ResourceRequiredException(n);
            }
            return new StatementTermImpl(n, eg);
        }
    };
    public static final Implementation rdfNodeFactory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isURI() || n.isBlank()) {
                return new StatementTermImpl(n, eg);
            }
            if (n.isLiteral()) {
                return new LiteralImpl(n, eg);
            }
            return null;
        }
    };
    private final Statement statement;

    public StatementTermImpl(Statement stmt) {
        this(stmt, (ModelCom)stmt.getModel());
    }

    public StatementTermImpl(Statement statement, ModelCom m) {
        super(NodeFactory.createTripleTerm(statement.asTriple()), m);
        this.statement = Objects.requireNonNull(statement);
    }

    public StatementTermImpl(Node n, EnhGraph m) {
        super(n, m);
        if (!n.isTripleTerm()) {
            throw new StmtTermRequiredException(n);
        }
        this.statement = StatementImpl.toStatement(n.getTriple(), (ModelCom)m);
    }

    @Override
    public Resource asResource() {
        throw new ResourceRequiredException(this.asNode());
    }

    @Override
    public Literal asLiteral() {
        throw new LiteralRequiredException(this.asNode());
    }

    @Override
    public StatementTerm asStatementTerm() {
        return this;
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Model getModel() {
        return (Model)((Object)this.enhGraph);
    }

    @Override
    public Object visitWith(RDFVisitor rv) {
        return rv.visitStmt(this, this.getStatement());
    }

    @Override
    public StatementTerm inModel(Model m) {
        if (this.getModel() == m) {
            return this;
        }
        return new StatementTermImpl(this.statement, (ModelCom)m);
    }
}

