/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.serializer;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.FmtUtils;

public abstract class FormatterBase {
    protected IndentedWriter out;
    protected SerializationContext context;

    protected FormatterBase(IndentedWriter _out, SerializationContext _context) {
        this.out = _out;
        this.context = _context;
    }

    public void startVisit() {
    }

    public void finishVisit() {
        this.out.flush();
    }

    protected void formatTriples(BasicPattern pattern) {
        FmtUtils.formatPattern(this.out, pattern, this.context);
    }

    protected void formatTriple(Triple tp) {
        this.out.print(this.slotToString(tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getObject()));
    }

    protected String slotToString(Node n) {
        return FmtUtils.stringForNode(n, this.context);
    }
}

