/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.type;

import java.util.Map;
import org.apache.fory.collection.Collections;
import org.apache.fory.util.Preconditions;

public class Types {
    public static final int BOOL = 1;
    public static final int INT8 = 2;
    public static final int INT16 = 3;
    public static final int INT32 = 4;
    public static final int VAR_INT32 = 5;
    public static final int INT64 = 6;
    public static final int VAR_INT64 = 7;
    public static final int SLI_INT64 = 8;
    public static final int FLOAT16 = 9;
    public static final int FLOAT32 = 10;
    public static final int FLOAT64 = 11;
    public static final int STRING = 12;
    public static final int ENUM = 13;
    public static final int NAMED_ENUM = 14;
    public static final int STRUCT = 15;
    public static final int COMPATIBLE_STRUCT = 16;
    public static final int NAMED_STRUCT = 17;
    public static final int NAMED_COMPATIBLE_STRUCT = 18;
    public static final int EXT = 19;
    public static final int NAMED_EXT = 20;
    public static final int LIST = 21;
    public static final int SET = 22;
    public static final int MAP = 23;
    public static final int DURATION = 24;
    public static final int TIMESTAMP = 25;
    public static final int LOCAL_DATE = 26;
    public static final int DECIMAL = 27;
    public static final int BINARY = 28;
    public static final int ARRAY = 29;
    public static final int BOOL_ARRAY = 30;
    public static final int INT8_ARRAY = 31;
    public static final int INT16_ARRAY = 32;
    public static final int INT32_ARRAY = 33;
    public static final int INT64_ARRAY = 34;
    public static final int FLOAT16_ARRAY = 35;
    public static final int FLOAT32_ARRAY = 36;
    public static final int FLOAT64_ARRAY = 37;
    public static final int ARROW_RECORD_BATCH = 38;
    public static final int ARROW_TABLE = 39;
    public static final int UNKNOWN = 63;
    private static final Map<Class, Integer> PRIMITIVE_TYPE_ID_MAP = Collections.ofHashMap(Boolean.TYPE, 1, Byte.TYPE, 2, Short.TYPE, 3, Integer.TYPE, 4, Long.TYPE, 6, Float.TYPE, 10, Double.TYPE, 11);

    public static boolean isStructType(int value) {
        return value == 15 || value == 16 || value == 17 || value == 18;
    }

    public static boolean isExtType(int value) {
        return value == 19 || value == 20;
    }

    public static boolean isEnumType(int value) {
        return value == 13 || value == 14;
    }

    public static boolean isUserDefinedType(byte typeId) {
        return Types.isStructType(typeId) || Types.isExtType(typeId) || Types.isEnumType(typeId);
    }

    public static int getPrimitiveTypeId(Class<?> cls) {
        Preconditions.checkArgument(cls.isPrimitive(), "Class %s is not primitive", cls, new Object[0]);
        return PRIMITIVE_TYPE_ID_MAP.getOrDefault(cls, -1);
    }

    public static boolean isPrimitiveType(int typeId) {
        switch (typeId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveArray(int typeId) {
        switch (typeId) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public static int getPrimitiveArrayTypeId(int typeId) {
        switch (typeId) {
            case 1: {
                return 30;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 32;
            }
            case 4: {
                return 33;
            }
            case 6: {
                return 34;
            }
            case 9: {
                return 35;
            }
            case 10: {
                return 36;
            }
            case 11: {
                return 37;
            }
        }
        throw new IllegalArgumentException(String.format("Type id %d is not a primitive id", typeId));
    }
}

