/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.result.ModelResultMatchers;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u001f\u0010\u000f\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u001f\u0010\u0015\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nJ$\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ'\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0010\"\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\bJ\u0006\u0010 \u001a\u00020\bJ\u000e\u0010!\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/springframework/test/web/servlet/result/ModelResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/ModelResultMatchers;", "attribute", "", "name", "", "value", "T", "matcher", "Lorg/hamcrest/Matcher;", "attributeDoesNotExist", "", "([Ljava/lang/String;)V", "attributeErrorCount", "expectedCount", "", "attributeExists", "attributeHasErrors", "attributeHasFieldErrorCode", "fieldName", "code", "attributeHasFieldErrors", "fieldNames", "(Ljava/lang/String;[Ljava/lang/String;)V", "attributeHasNoErrors", "errorCount", "hasErrors", "hasNoErrors", "size", "spring-test"})
public final class ModelResultMatchersDsl {
    private final ModelResultMatchers matchers;
    private final ResultActions actions;

    public final <T> void attribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attribute(name, matcher));
    }

    public final void attribute(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attribute(name, value));
    }

    public final void attributeExists(String ... name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeExists(Arrays.copyOf(name, name.length)));
    }

    public final void attributeDoesNotExist(String ... name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeDoesNotExist(Arrays.copyOf(name, name.length)));
    }

    public final void attributeErrorCount(@NotNull String name, int expectedCount) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeErrorCount(name, expectedCount));
    }

    public final void attributeHasErrors(String ... name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeHasErrors(Arrays.copyOf(name, name.length)));
    }

    public final void attributeHasNoErrors(String ... name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attributeHasNoErrors(Arrays.copyOf(name, name.length)));
    }

    public final void attributeHasFieldErrors(@NotNull String name, String ... fieldNames) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)fieldNames, (String)"fieldNames");
        this.actions.andExpect(this.matchers.attributeHasFieldErrors(name, Arrays.copyOf(fieldNames, fieldNames.length)));
    }

    public final void attributeHasFieldErrorCode(@NotNull String name, @NotNull String fieldName, @NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        this.actions.andExpect(this.matchers.attributeHasFieldErrorCode(name, fieldName, code));
    }

    public final void attributeHasFieldErrorCode(@NotNull String name, @NotNull String fieldName, @NotNull Matcher<String> matcher) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attributeHasFieldErrorCode(name, fieldName, matcher));
    }

    public final void errorCount(int expectedCount) {
        this.actions.andExpect(this.matchers.errorCount(expectedCount));
    }

    public final void hasErrors() {
        this.actions.andExpect(this.matchers.hasErrors());
    }

    public final void hasNoErrors() {
        this.actions.andExpect(this.matchers.hasNoErrors());
    }

    public final void size(int size) {
        this.actions.andExpect(this.matchers.size(size));
    }

    public ModelResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkParameterIsNotNull((Object)actions, (String)"actions");
        this.actions = actions;
        ModelResultMatchers modelResultMatchers = MockMvcResultMatchers.model();
        Intrinsics.checkExpressionValueIsNotNull((Object)modelResultMatchers, (String)"MockMvcResultMatchers.model()");
        this.matchers = modelResultMatchers;
    }
}

