/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.elicitation;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.springaicommunity.mcp.annotation.McpElicitation;

public abstract class AbstractMcpElicitationMethodCallback {
    protected final Method method;
    protected final Object bean;

    protected AbstractMcpElicitationMethodCallback(Method method, Object bean) {
        Assert.notNull((Object)method, (String)"Method can't be null!");
        Assert.notNull((Object)bean, (String)"Bean can't be null!");
        this.method = method;
        this.bean = bean;
        this.validateMethod(this.method);
    }

    protected void validateMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        this.validateReturnType(method);
        this.validateParameters(method);
    }

    protected abstract void validateReturnType(Method var1);

    protected void validateParameters(Method method) {
        Parameter[] parameters = method.getParameters();
        if (parameters.length < 1) {
            throw new IllegalArgumentException("Method must have at least 1 parameter (ElicitRequest): " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + parameters.length + " parameters");
        }
        if (parameters.length == 1) {
            if (!McpSchema.ElicitRequest.class.isAssignableFrom(parameters[0].getType())) {
                throw new IllegalArgumentException("Single parameter must be of type ElicitRequest: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has parameter of type " + parameters[0].getType().getName());
            }
        } else {
            throw new IllegalArgumentException("Currently only methods with a single ElicitRequest parameter are supported: " + method.getName() + " in " + method.getDeclaringClass().getName() + " has " + parameters.length + " parameters");
        }
    }

    protected Object[] buildArgs(Method method, Object exchange, McpSchema.ElicitRequest request) {
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        if (parameters.length != 1) {
            throw new IllegalArgumentException("Currently only methods with a single ElicitRequest parameter are supported");
        }
        args[0] = request;
        return args;
    }

    protected abstract boolean isExchangeType(Class<?> var1);

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, R>, R> {
        protected Method method;
        protected Object bean;

        protected AbstractBuilder() {
        }

        public T method(Method method) {
            this.method = method;
            return (T)this;
        }

        public T bean(Object bean) {
            this.bean = bean;
            return (T)this;
        }

        public T elicitation(McpElicitation elicitation) {
            return (T)this;
        }

        protected void validate() {
            if (this.method == null) {
                throw new IllegalArgumentException("Method must not be null");
            }
            if (this.bean == null) {
                throw new IllegalArgumentException("Bean must not be null");
            }
        }

        public abstract R build();
    }

    public static class McpElicitationMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public McpElicitationMethodException(String message, Throwable cause) {
            super(message, cause);
        }

        public McpElicitationMethodException(String message) {
            super(message);
        }
    }
}

