/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class EqualityDeleteWriter<T>
implements FileWriter<T, DeleteWriteResult> {
    private final FileAppender<T> appender;
    private final FileFormat format;
    private final String location;
    private final PartitionSpec spec;
    private final StructLike partition;
    private final ByteBuffer keyMetadata;
    private final int[] equalityFieldIds;
    private final SortOrder sortOrder;
    private DeleteFile deleteFile = null;

    public EqualityDeleteWriter(FileAppender<T> appender, FileFormat format, String location, PartitionSpec spec, StructLike partition, EncryptionKeyMetadata keyMetadata, SortOrder sortOrder, int ... equalityFieldIds) {
        this.appender = appender;
        this.format = format;
        this.location = location;
        this.spec = spec;
        this.partition = partition;
        this.keyMetadata = keyMetadata != null ? keyMetadata.buffer() : null;
        this.sortOrder = sortOrder;
        this.equalityFieldIds = equalityFieldIds;
    }

    @Override
    public void write(T row) {
        this.appender.add(row);
    }

    @Override
    public long length() {
        return this.appender.length();
    }

    @Override
    public void close() throws IOException {
        if (this.deleteFile == null) {
            this.appender.close();
            this.deleteFile = FileMetadata.deleteFileBuilder(this.spec).ofEqualityDeletes(this.equalityFieldIds).withFormat(this.format).withPath(this.location).withPartition(this.partition).withEncryptionKeyMetadata(this.keyMetadata).withFileSizeInBytes(this.appender.length()).withMetrics(this.appender.metrics()).withSplitOffsets(this.appender.splitOffsets()).withSortOrder(this.sortOrder).build();
        }
    }

    public DeleteFile toDeleteFile() {
        Preconditions.checkState((this.deleteFile != null ? 1 : 0) != 0, (Object)"Cannot create delete file from unclosed writer");
        return this.deleteFile;
    }

    @Override
    public DeleteWriteResult result() {
        return new DeleteWriteResult(this.toDeleteFile());
    }
}

