/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.RetryWhen;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.RetryWhenConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class RetryWhenConfigImpl
implements RetryWhenConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final RetryWhen instance;
    private Class<? extends Predicate<Object>> _result;
    private Class<? extends Predicate<Throwable>> _exception;

    private RetryWhenConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(RetryWhen.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.retryWhen;
    }

    public static RetryWhenConfigImpl create(FaultToleranceMethod method) {
        if (method.retryWhen == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"retry-when.enabled", (String)"RetryWhen/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new RetryWhenConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return RetryWhen.class;
    }

    public Class<? extends Predicate<Object>> result() {
        if (this._result == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry-when.result";
            Object oldKey = this.configKey + "/RetryWhen/result";
            this._result = config.getOptionalValue((String)newKey, Class.class).or(() -> RetryWhenConfigImpl.lambda$result$0(config, (String)oldKey)).orElse(null);
            if (this._result == null) {
                newKey = "smallrye.faulttolerance.global.retry-when.result";
                oldKey = "RetryWhen/result";
                this._result = config.getOptionalValue((String)newKey, Class.class).or(() -> RetryWhenConfigImpl.lambda$result$1(config, (String)oldKey)).orElse(null);
            }
            if (this._result == null) {
                this._result = this.instance.result();
            }
        }
        return this._result;
    }

    public Class<? extends Predicate<Throwable>> exception() {
        if (this._exception == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".retry-when.exception";
            Object oldKey = this.configKey + "/RetryWhen/exception";
            this._exception = config.getOptionalValue((String)newKey, Class.class).or(() -> RetryWhenConfigImpl.lambda$exception$2(config, (String)oldKey)).orElse(null);
            if (this._exception == null) {
                newKey = "smallrye.faulttolerance.global.retry-when.exception";
                oldKey = "RetryWhen/exception";
                this._exception = config.getOptionalValue((String)newKey, Class.class).or(() -> RetryWhenConfigImpl.lambda$exception$3(config, (String)oldKey)).orElse(null);
            }
            if (this._exception == null) {
                this._exception = this.instance.exception();
            }
        }
        return this._exception;
    }

    public void materialize() {
        this.result();
        this.exception();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @RetryWhen on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @RetryWhen." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$exception$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$exception$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$result$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$result$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }
}

