/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.attribute;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeBuilder;
import io.quarkus.vertx.http.runtime.attribute.ReadOnlyAttributeException;
import io.vertx.ext.web.RoutingContext;

public class NullAttribute
implements ExchangeAttribute {
    public static final String NAME = "%{NULL}";
    public static final NullAttribute INSTANCE = new NullAttribute();

    private NullAttribute() {
    }

    @Override
    public String readAttribute(RoutingContext exchange) {
        return null;
    }

    @Override
    public void writeAttribute(RoutingContext exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException(NAME, newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "null";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(NullAttribute.NAME)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

