/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.ByteBuffer;

public class VarLong {
    public static long decode(ByteString bytes) {
        return VarLong.decode(bytes.asReadOnlyByteBuffer());
    }

    private static long decode(ByteBuffer buffer) {
        long temp = buffer.get();
        if (temp >= 0L) {
            return temp;
        }
        long result = temp & 0x7FL;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 7;
        }
        result |= (temp & 0x7FL) << 7;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 14;
        }
        result |= (temp & 0x7FL) << 14;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 21;
        }
        result |= (temp & 0x7FL) << 21;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 28;
        }
        result |= (temp & 0x7FL) << 28;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 35;
        }
        result |= (temp & 0x7FL) << 35;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 42;
        }
        result |= (temp & 0x7FL) << 42;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 49;
        }
        result |= (temp & 0x7FL) << 49;
        temp = buffer.get();
        if (temp >= 0L) {
            return result |= temp << 56;
        }
        result |= (temp & 0x7FL) << 56;
        return result |= (long)buffer.get() << 63;
    }

    public static ByteString encode(long value) {
        int size = VarLong.sizing(value);
        ByteBuffer buffer = ByteBuffer.allocate(size);
        VarLong.encode(value, buffer);
        return UnsafeByteOperations.unsafeWrap((byte[])buffer.array());
    }

    private static int sizing(long value) {
        int size = 0;
        do {
            ++size;
        } while ((value >>>= 7) != 0L);
        return size;
    }

    private static void encode(long value, ByteBuffer buffer) {
        while (true) {
            int currentBits = (int)value & 0x7F;
            if ((value >>>= 7) == 0L) {
                buffer.put((byte)currentBits);
                return;
            }
            buffer.put((byte)(currentBits | 0x80));
        }
    }
}

