/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.column;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;

public class SqlXmlColumnMapping
extends LongVarcharColumnMapping {
    public SqlXmlColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    @Override
    public int getJDBCType() {
        return 2009;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getJDBCType());
            } else {
                SQLXML sqlxml = ps.getConnection().createSQLXML();
                sqlxml.setString(value);
                ps.setSQLXML(param, sqlxml);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055001", (Object[])new Object[]{"String", value}), (Throwable)e);
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        String value;
        try {
            SQLXML sqlxml = rs.getSQLXML(param);
            value = sqlxml.getString();
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(Localiser.msg((String)"055002", (Object[])new Object[]{"String", "" + param, this.column, e.getMessage()}), (Throwable)e);
        }
        return value;
    }
}

