/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.AllDataFilesTable;
import org.apache.iceberg.AllDeleteFilesTable;
import org.apache.iceberg.AllEntriesTable;
import org.apache.iceberg.AllFilesTable;
import org.apache.iceberg.AllManifestsTable;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.DeleteFilesTable;
import org.apache.iceberg.FilesTable;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataLogEntriesTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.PositionDeletesTable;
import org.apache.iceberg.RefsTable;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;

public class MetadataTableUtils {
    private MetadataTableUtils() {
    }

    public static boolean hasMetadataTableName(TableIdentifier identifier) {
        return MetadataTableType.from(identifier.name()) != null;
    }

    public static Table createMetadataTableInstance(Table table, MetadataTableType type) {
        if (table instanceof BaseTable) {
            return MetadataTableUtils.createMetadataTableInstance(table, MetadataTableUtils.metadataTableName(table.name(), type), type);
        }
        if (table instanceof HasTableOperations) {
            return MetadataTableUtils.createMetadataTableInstance(((HasTableOperations)((Object)table)).operations(), table.name(), MetadataTableUtils.metadataTableName(table.name(), type), type);
        }
        throw new IllegalArgumentException(String.format("Cannot create metadata table for table %s: table is not a base table or does not have table operations", table));
    }

    public static Table createMetadataTableInstance(TableOperations ops, String baseTableName, String metadataTableName, MetadataTableType type) {
        BaseTable baseTable = new BaseTable(ops, baseTableName);
        return MetadataTableUtils.createMetadataTableInstance(baseTable, metadataTableName, type);
    }

    private static Table createMetadataTableInstance(Table baseTable, String metadataTableName, MetadataTableType type) {
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(baseTable, metadataTableName);
            }
            case FILES: {
                return new FilesTable(baseTable, metadataTableName);
            }
            case DATA_FILES: {
                return new DataFilesTable(baseTable, metadataTableName);
            }
            case DELETE_FILES: {
                return new DeleteFilesTable(baseTable, metadataTableName);
            }
            case HISTORY: {
                return new HistoryTable(baseTable, metadataTableName);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(baseTable, metadataTableName);
            }
            case METADATA_LOG_ENTRIES: {
                return new MetadataLogEntriesTable(baseTable, metadataTableName);
            }
            case REFS: {
                return new RefsTable(baseTable, metadataTableName);
            }
            case MANIFESTS: {
                return new ManifestsTable(baseTable, metadataTableName);
            }
            case PARTITIONS: {
                return new PartitionsTable(baseTable, metadataTableName);
            }
            case ALL_DATA_FILES: {
                return new AllDataFilesTable(baseTable, metadataTableName);
            }
            case ALL_DELETE_FILES: {
                return new AllDeleteFilesTable(baseTable, metadataTableName);
            }
            case ALL_FILES: {
                return new AllFilesTable(baseTable, metadataTableName);
            }
            case ALL_MANIFESTS: {
                return new AllManifestsTable(baseTable, metadataTableName);
            }
            case ALL_ENTRIES: {
                return new AllEntriesTable(baseTable, metadataTableName);
            }
            case POSITION_DELETES: {
                return new PositionDeletesTable(baseTable, metadataTableName);
            }
        }
        throw new NoSuchTableException("Unknown metadata table type: %s for %s", new Object[]{type, metadataTableName});
    }

    public static Table createMetadataTableInstance(TableOperations ops, String catalogName, TableIdentifier baseTableIdentifier, TableIdentifier metadataTableIdentifier, MetadataTableType type) {
        String baseTableName = BaseMetastoreCatalog.fullTableName(catalogName, baseTableIdentifier);
        String metadataTableName = BaseMetastoreCatalog.fullTableName(catalogName, metadataTableIdentifier);
        return MetadataTableUtils.createMetadataTableInstance(ops, baseTableName, metadataTableName, type);
    }

    private static String metadataTableName(String tableName, MetadataTableType type) {
        return tableName + (tableName.contains("/") ? "#" : ".") + type.name().toLowerCase(Locale.ROOT);
    }
}

