/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.cli.EscapeCRLFHelper;
import org.apache.hadoop.hive.common.cli.ShellCmdExecutor;
import org.apache.hadoop.hive.common.io.CachingPrintStream;
import org.apache.hadoop.hive.common.io.FetchCallback;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.Validator;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.tez.TezJobExecHelper;
import org.apache.hadoop.hive.ql.metadata.HiveMaterializedViewsRegistry;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.MatchingStringsCompleter;
import org.apache.hive.common.util.ShutdownHookManager;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliDriver {
    public static String prompt = null;
    public static String prompt2 = null;
    public static final int LINES_TO_FETCH = 40;
    public static final int DELIMITED_CANDIDATE_THRESHOLD = 10;
    public static final String HIVERCFILE = ".hiverc";
    private final SessionState.LogHelper console;
    protected LineReader reader;
    private Configuration conf;

    public CliDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new Configuration();
        Logger LOG = LoggerFactory.getLogger((String)"CliDriver");
        LOG.debug("CliDriver inited with classpath {}", (Object)System.getProperty("java.class.path"));
        this.console = new SessionState.LogHelper(LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse processCmd(String cmd) throws CommandProcessorException {
        CliSessionState ss = (CliSessionState)SessionState.get();
        ss.setLastCommand(cmd);
        ss.err.flush();
        try {
            ss.updateThreadName();
            CommandProcessorResponse commandProcessorResponse = this.processCmd1(cmd);
            return commandProcessorResponse;
        }
        finally {
            ss.resetThreadName();
        }
    }

    public CommandProcessorResponse processCmd1(String cmd) throws CommandProcessorException {
        CliSessionState ss = (CliSessionState)SessionState.get();
        String cmd_trimmed = HiveStringUtils.removeComments((String)cmd).trim();
        String[] tokens = this.tokenizeCmd(cmd_trimmed);
        CommandProcessorResponse response = new CommandProcessorResponse();
        if (cmd_trimmed.toLowerCase().equals("quit") || cmd_trimmed.toLowerCase().equals("exit")) {
            ss.close();
            ExitUtil.terminate((int)0);
        } else {
            if (tokens[0].equalsIgnoreCase("source")) {
                String cmd_1 = this.getFirstCmd(cmd_trimmed, tokens[0].length());
                cmd_1 = new VariableSubstitution(new HiveVariableSource(this){

                    public Map<String, String> getHiveVariable() {
                        return SessionState.get().getHiveVariables();
                    }
                }).substitute(ss.getConf(), cmd_1);
                File sourceFile = new File(cmd_1);
                if (!sourceFile.isFile()) {
                    this.console.printError("File: " + cmd_1 + " is not a file.");
                    throw new CommandProcessorException(1);
                }
                try {
                    response = this.processFile(cmd_1);
                }
                catch (IOException e) {
                    this.console.printError("Failed processing file " + cmd_1 + " " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
                    throw new CommandProcessorException(1);
                }
            }
            if (cmd_trimmed.startsWith("!")) {
                String shell_cmd = cmd.trim().substring(1);
                shell_cmd = new VariableSubstitution(new HiveVariableSource(this){

                    public Map<String, String> getHiveVariable() {
                        return SessionState.get().getHiveVariables();
                    }
                }).substitute(ss.getConf(), shell_cmd);
                try {
                    ShellCmdExecutor executor = new ShellCmdExecutor(shell_cmd, (PrintStream)ss.out, (PrintStream)ss.err);
                    int responseCode = executor.execute();
                    if (responseCode != 0) {
                        this.console.printError("Command failed with exit code = " + String.valueOf(response));
                        ss.resetThreadName();
                        throw new CommandProcessorException(responseCode);
                    }
                    response = new CommandProcessorResponse();
                }
                catch (Exception e) {
                    this.console.printError("Exception raised from Shell command " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
                    throw new CommandProcessorException(1);
                }
            }
            try (CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)((HiveConf)this.conf));){
                response = proc instanceof IDriver ? this.processLocalCmd(cmd, proc, ss) : this.processLocalCmd(cmd_trimmed, proc, ss);
            }
            catch (SQLException e) {
                this.console.printError("Failed processing command " + tokens[0] + " " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
                throw new CommandProcessorException(1);
            }
            catch (CommandProcessorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return response;
    }

    void setConf(Configuration conf) {
        this.conf = conf;
    }

    private String getFirstCmd(String cmd, int length) {
        return cmd.substring(length).trim();
    }

    private String[] tokenizeCmd(String cmd) {
        return cmd.split("\\s+");
    }

    CommandProcessorResponse processLocalCmd(String cmd, CommandProcessor proc, CliSessionState ss) throws CommandProcessorException {
        CommandProcessorResponse response;
        block17: {
            block18: {
                Object callback;
                boolean escapeCRLF = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_ESCAPE_CRLF);
                response = new CommandProcessorResponse();
                if (proc == null) break block17;
                if (!(proc instanceof IDriver)) break block18;
                IDriver qp = (IDriver)proc;
                SessionStream out = ss.out;
                long start = System.currentTimeMillis();
                if (ss.getIsVerbose()) {
                    out.println(cmd);
                }
                ShimLoader.getHadoopShims().setHadoopQueryContext(String.format("%s_User:%s", qp.getQueryState().getQueryId(), ss.getUserName()));
                try {
                    response = qp.run(cmd);
                }
                catch (CommandProcessorException e) {
                    qp.close();
                    ShimLoader.getHadoopShims().setHadoopSessionContext(String.format("%s_User:%s", ss.getSessionId(), ss.getUserName()));
                    throw e;
                }
                long end = System.currentTimeMillis();
                double timeTaken = (double)(end - start) / 1000.0;
                ArrayList res = new ArrayList();
                this.printHeader(qp, (PrintStream)out);
                int counter = 0;
                try {
                    if (out instanceof FetchCallback) {
                        callback = (FetchCallback)out;
                        callback.fetchStarted();
                    }
                    while (qp.getResults(res)) {
                        for (String r : res) {
                            if (escapeCRLF) {
                                r = EscapeCRLFHelper.escapeCRLF((String)r);
                            }
                            out.println(r);
                        }
                        counter += res.size();
                        res.clear();
                        if (!out.checkError()) continue;
                    }
                }
                catch (IOException e) {
                    try {
                        this.console.printError("Failed with exception " + e.getClass().getName() + ":" + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
                        throw new CommandProcessorException(1);
                    }
                    catch (Throwable throwable) {
                        qp.close();
                        ShimLoader.getHadoopShims().setHadoopSessionContext(String.format("%s_User:%s", ss.getSessionId(), ss.getUserName()));
                        if (out instanceof FetchCallback) {
                            FetchCallback callback2 = (FetchCallback)out;
                            callback2.fetchFinished();
                        }
                        this.console.printInfo("Time taken: " + timeTaken + " seconds" + (String)(counter == 0 ? "" : ", Fetched: " + counter + " row(s)"));
                        throw throwable;
                    }
                }
                qp.close();
                ShimLoader.getHadoopShims().setHadoopSessionContext(String.format("%s_User:%s", ss.getSessionId(), ss.getUserName()));
                if (out instanceof FetchCallback) {
                    callback = (FetchCallback)out;
                    callback.fetchFinished();
                }
                this.console.printInfo("Time taken: " + timeTaken + " seconds" + (String)(counter == 0 ? "" : ", Fetched: " + counter + " row(s)"));
                break block17;
            }
            String firstToken = this.tokenizeCmd(cmd.trim())[0];
            String cmd_1 = this.getFirstCmd(cmd.trim(), firstToken.length());
            if (ss.getIsVerbose()) {
                ss.out.println(firstToken + " " + cmd_1);
            }
            try {
                CommandProcessorResponse res = proc.run(cmd_1);
                if (res.getMessage() != null) {
                    this.console.printInfo(res.getMessage());
                }
                return res;
            }
            catch (CommandProcessorException e) {
                ss.out.println("Query returned non-zero code: " + e.getResponseCode() + ", cause: " + e.getMessage());
                throw e;
            }
        }
        return response;
    }

    private void printHeader(IDriver qp, PrintStream out) {
        List fieldSchemas = qp.getSchema().getFieldSchemas();
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) && fieldSchemas != null) {
            boolean first_col = true;
            for (FieldSchema fs : fieldSchemas) {
                if (!first_col) {
                    out.print('\t');
                }
                out.print(fs.getName());
                first_col = false;
            }
            out.println();
        }
    }

    public CommandProcessorResponse processLine(String line) throws CommandProcessorException {
        return this.processLine(line, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse processLine(String line, boolean allowInterrupting) throws CommandProcessorException {
        CommandProcessorResponse commandProcessorResponse;
        block11: {
            Terminal.SignalHandler oldSignal = null;
            Terminal.Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = Terminal.Signal.INT;
                oldSignal = this.reader.getTerminal().handle(interruptSignal, new Terminal.SignalHandler(){
                    private boolean interruptRequested;

                    public void handle(Terminal.Signal signal) {
                        boolean initialRequest = !this.interruptRequested;
                        this.interruptRequested = true;
                        if (!initialRequest) {
                            CliDriver.this.console.printInfo("Exiting the JVM");
                            ExitUtil.terminate((int)127);
                        }
                        CliDriver.this.console.printInfo("Interrupting... Be patient, this might take some time.");
                        CliDriver.this.console.printInfo("Press Ctrl+C again to kill JVM");
                        HadoopJobExecHelper.killRunningJobs();
                        if ("tez".equalsIgnoreCase(HiveConf.getVar((Configuration)CliDriver.this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
                            TezJobExecHelper.killRunningJobs();
                        }
                        HiveInterruptUtils.interrupt();
                    }
                });
            }
            try {
                CommandProcessorResponse lastRet = new CommandProcessorResponse();
                List<String> commands = CliDriver.splitSemiColon(line);
                StringBuilder command = new StringBuilder();
                for (String oneCmd : commands) {
                    if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
                        command.append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd) + ";");
                        continue;
                    }
                    command.append(oneCmd);
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)command.toString())) continue;
                    try {
                        CommandProcessorResponse ret;
                        lastRet = ret = this.processCmd(command.toString());
                    }
                    catch (CommandProcessorException e) {
                        boolean ignoreErrors = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLI_IGNORE_ERRORS);
                        if (ignoreErrors) continue;
                        throw e;
                    }
                    finally {
                        command.setLength(0);
                    }
                }
                commandProcessorResponse = lastRet;
                if (oldSignal == null) break block11;
            }
            catch (Throwable throwable) {
                if (oldSignal != null) {
                    this.reader.getTerminal().handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            this.reader.getTerminal().handle(interruptSignal, oldSignal);
        }
        return commandProcessorResponse;
    }

    public static List<String> splitSemiColon(String line) {
        boolean inQuotes = false;
        boolean escape = false;
        ArrayList<String> ret = new ArrayList<String>();
        char quoteChar = '\"';
        int beginIndex = 0;
        for (int index = 0; index < line.length(); ++index) {
            char c = line.charAt(index);
            switch (c) {
                case ';': {
                    if (inQuotes) break;
                    ret.add(line.substring(beginIndex, index));
                    beginIndex = index + 1;
                    break;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    if (escape) break;
                    if (!inQuotes) {
                        quoteChar = c;
                        inQuotes = !inQuotes;
                        break;
                    }
                    if (c != quoteChar) break;
                    inQuotes = !inQuotes;
                    break;
                }
            }
            if (escape) {
                escape = false;
                continue;
            }
            if (c != '\\') continue;
            escape = true;
        }
        if (beginIndex < line.length()) {
            ret.add(line.substring(beginIndex));
        }
        return ret;
    }

    public CommandProcessorResponse processReader(BufferedReader r) throws IOException, CommandProcessorException {
        String line;
        StringBuilder qsb = new StringBuilder();
        while ((line = r.readLine()) != null) {
            if (line.startsWith("--")) continue;
            qsb.append(line + "\n");
        }
        return this.processLine(qsb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandProcessorResponse processFile(String fileName) throws IOException, CommandProcessorException {
        CommandProcessorResponse commandProcessorResponse;
        LocalFileSystem fs;
        Path path = new Path(fileName);
        if (!path.toUri().isAbsolute()) {
            fs = FileSystem.getLocal((Configuration)this.conf);
            path = fs.makeQualified(path);
        } else {
            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.conf);
        }
        BufferedReader bufferReader = null;
        try {
            bufferReader = new BufferedReader(new InputStreamReader((InputStream)fs.open(path), StandardCharsets.UTF_8));
            commandProcessorResponse = this.processReader(bufferReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(bufferReader);
            throw throwable;
        }
        IOUtils.closeStream((Closeable)bufferReader);
        return commandProcessorResponse;
    }

    public void processInitFiles(CliSessionState ss) throws IOException, CommandProcessorException {
        boolean saveSilent = ss.getIsSilent();
        ss.setIsSilent(true);
        for (String initFile : ss.initFiles) {
            this.processFileExitOnFailure(initFile);
        }
        if (ss.initFiles.size() == 0) {
            String hivercUser;
            String hivercDefault;
            if (System.getenv("HIVE_HOME") != null && new File(hivercDefault = System.getenv("HIVE_HOME") + File.separator + "bin" + File.separator + HIVERCFILE).exists()) {
                this.processFileExitOnFailure(hivercDefault);
                this.console.printError("Putting the global hiverc in $HIVE_HOME/bin/.hiverc is deprecated. Please use $HIVE_CONF_DIR/.hiverc instead.");
            }
            if (System.getenv("HIVE_CONF_DIR") != null && new File(hivercDefault = System.getenv("HIVE_CONF_DIR") + File.separator + HIVERCFILE).exists()) {
                this.processFileExitOnFailure(hivercDefault);
            }
            if (System.getProperty("user.home") != null && new File(hivercUser = System.getProperty("user.home") + File.separator + HIVERCFILE).exists()) {
                this.processFileExitOnFailure(hivercUser);
            }
        }
        ss.setIsSilent(saveSilent);
    }

    private void processFileExitOnFailure(String fileName) throws IOException {
        try {
            this.processFile(fileName);
        }
        catch (CommandProcessorException e) {
            ExitUtil.terminate((int)e.getResponseCode());
        }
    }

    private void processLineExitOnFailure(String command) throws IOException {
        try {
            this.processLine(command);
        }
        catch (CommandProcessorException e) {
            ExitUtil.terminate((int)e.getResponseCode());
        }
    }

    public void processSelectDatabase(CliSessionState ss) throws IOException, CommandProcessorException {
        String database = ss.database;
        if (database != null) {
            this.processLineExitOnFailure("use " + database + ";");
        }
    }

    public static Completer[] getCommandCompleter() {
        ArrayList<Object> candidateStrings = new ArrayList<Object>();
        for (String s : FunctionRegistry.getFunctionNames()) {
            if (s.matches("[a-z_]+")) {
                candidateStrings.add(s + "(");
                continue;
            }
            candidateStrings.add(s);
        }
        for (String s : HiveParser.getKeywords()) {
            candidateStrings.add(s);
            candidateStrings.add(s.toLowerCase());
        }
        MatchingStringsCompleter strCompleter = new MatchingStringsCompleter(candidateStrings);
        ArgumentCompleter argCompleter = new ArgumentCompleter(new Completer[]{strCompleter});
        argCompleter.setStrict(false);
        Completer customCompleter = (reader, line, candidates) -> {
            String candidateStr;
            argCompleter.complete(reader, line, candidates);
            candidates.forEach(System.out::println);
            if (candidates.size() == 1 && (candidateStr = ((Candidate)candidates.get(0)).value()).endsWith("( ")) {
                candidates.set(0, new Candidate(candidateStr.trim()));
            }
        };
        ArrayList<String> vars = new ArrayList<String>();
        for (HiveConf.ConfVars conf : HiveConf.ConfVars.values()) {
            vars.add(conf.varname);
        }
        MatchingStringsCompleter confCompleter = new MatchingStringsCompleter(vars){

            public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
                super.complete(reader, line, candidates);
                int cursor = line.cursor();
                if (candidates.isEmpty() && cursor > 1 && line.word().charAt(cursor - 1) == '=') {
                    HiveConf.ConfVars confVars = HiveConf.getConfVars((String)line.word().substring(0, cursor - 1));
                    if (confVars == null) {
                        return;
                    }
                    if (confVars.getValidator() instanceof Validator.StringSet) {
                        Validator.StringSet validator = (Validator.StringSet)confVars.getValidator();
                        validator.getExpected().stream().map(Candidate::new).forEach(candidates::add);
                    } else if (confVars.getValidator() != null) {
                        candidates.add(new Candidate(confVars.getValidator().toDescription()));
                    } else {
                        candidates.add(new Candidate("Expects " + confVars.typeString() + " type value"));
                    }
                    return;
                }
                if (candidates.size() > 10) {
                    LinkedHashSet<Candidate> delimited = new LinkedHashSet<Candidate>();
                    for (Candidate candidate : candidates) {
                        Iterator it = Splitter.on((String)".").split(candidate.value().subSequence(cursor, candidate.value().length())).iterator();
                        if (it.hasNext()) {
                            String next = (String)it.next();
                            if (next.isEmpty()) {
                                next = ".";
                            }
                            candidate = new Candidate((String)(line.line() != null ? line.line().substring(0, cursor) + next : next));
                        }
                        delimited.add(candidate);
                    }
                    candidates.clear();
                    candidates.addAll(delimited);
                }
            }
        };
        MatchingStringsCompleter setCompleter = new MatchingStringsCompleter(new String[]{"set"});
        ArgumentCompleter propCompleter = new ArgumentCompleter(new Completer[]{setCompleter, confCompleter}){

            public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
                super.complete(reader, line, candidates);
                if (candidates.size() == 1) {
                    candidates.set(0, new Candidate(candidates.get(0).value().trim()));
                }
            }
        };
        return new Completer[]{propCompleter, customCompleter};
    }

    public static void main(String[] args) throws Exception {
        int ret = new CliDriver().run(args);
        ExitUtil.terminate((int)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        String logInitDetailMessage;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            return 1;
        }
        boolean logInitFailed = false;
        try {
            logInitDetailMessage = LogUtils.initHiveLog4j();
        }
        catch (LogUtils.LogInitializationException e) {
            logInitFailed = true;
            logInitDetailMessage = e.getMessage();
        }
        CliSessionState ss = new CliSessionState(this.getConf());
        ss.in = System.in;
        try {
            ss.out = new SessionStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
            ss.info = new SessionStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            ss.err = new CachingPrintStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return 3;
        }
        if (!oproc.process_stage2(ss)) {
            return 2;
        }
        if (!ss.getIsSilent()) {
            if (logInitFailed) {
                System.err.println(logInitDetailMessage);
            } else {
                SessionState.getConsole().printInfo(logInitDetailMessage);
            }
        }
        HiveConf conf = ss.getConf();
        for (Map.Entry<Object, Object> item : ss.cmdProperties.entrySet()) {
            conf.set((String)item.getKey(), (String)item.getValue());
            ss.getOverriddenConfigurations().put((String)item.getKey(), (String)item.getValue());
        }
        prompt = conf.getVar(HiveConf.ConfVars.CLI_PROMPT);
        prompt = new VariableSubstitution(new HiveVariableSource(this){

            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(conf, prompt);
        prompt2 = CliDriver.spacesForString(prompt);
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_TEZ_SESSION_ASYNC)) {
            SessionState.beginStart((SessionState)ss, (SessionState.LogHelper)this.console);
        } else {
            SessionState.start((SessionState)ss);
        }
        ss.updateThreadName();
        CalcitePlanner.warmup();
        HiveMaterializedViewsRegistry.get().init();
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_ENABLED)) {
            HiveMetaStoreClientWithLocalCache.init((Configuration)conf);
        }
        try {
            this.executeDriver(ss, conf, oproc);
            int n = 0;
            return n;
        }
        catch (CommandProcessorException e) {
            int n = e.getResponseCode();
            return n;
        }
        finally {
            SessionState.endStart((SessionState)ss);
            ss.resetThreadName();
            ss.close();
        }
    }

    protected HiveConf getConf() {
        return new HiveConf(SessionState.class);
    }

    private CommandProcessorResponse executeDriver(CliSessionState ss, HiveConf conf, OptionsProcessor oproc) throws Exception {
        Object line;
        CliDriver cli = this.newCliDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        cli.processSelectDatabase(ss);
        cli.processInitFiles(ss);
        if (ss.execString != null) {
            return cli.processLine(ss.execString);
        }
        try {
            if (ss.fileName != null) {
                return cli.processFile(ss.fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open input file for reading. (" + e.getMessage() + ")");
            throw new CommandProcessorException(3);
        }
        if ("mr".equals(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            this.console.printInfo(HiveConf.generateMrDeprecationWarning());
        }
        this.setupLineReader();
        CommandProcessorResponse response = new CommandProcessorResponse();
        StringBuilder prefix = new StringBuilder();
        String curDB = CliDriver.getFormattedDb(conf, ss);
        String curPrompt = prompt + curDB;
        String dbSpaces = CliDriver.spacesForString(curDB);
        while ((line = this.reader.readLine(curPrompt + "> ")) != null) {
            if (!prefix.toString().equals("")) {
                prefix.append('\n');
            }
            if (((String)line).trim().startsWith("--")) continue;
            if (((String)line).trim().endsWith(";") && !((String)line).trim().endsWith("\\;")) {
                line = String.valueOf(prefix) + (String)line;
                response = cli.processLine((String)line, true);
                prefix.setLength(0);
                curDB = CliDriver.getFormattedDb(conf, ss);
                curPrompt = prompt + curDB;
                dbSpaces = dbSpaces.length() == curDB.length() ? dbSpaces : CliDriver.spacesForString(curDB);
                continue;
            }
            prefix.append((String)line);
            curPrompt = prompt2 + dbSpaces;
        }
        return response;
    }

    protected CliDriver newCliDriver() {
        return new CliDriver();
    }

    private String setupCmdHistory() {
        String HISTORYFILE = ".hivehistory";
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                return historyDirectory + File.separator + ".hivehistory";
            }
            System.err.println("WARNING: Directory for Hive history file: " + historyDirectory + " does not exist.   History will not be available during this session.");
        }
        catch (Exception e) {
            System.err.println("WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.");
            System.err.println(e.getMessage());
            return null;
        }
        ShutdownHookManager.addShutdownHook(() -> {
            History h = this.reader.getHistory();
            try {
                h.save();
            }
            catch (IOException e) {
                System.err.println("WARNING: Failed to write command history file: " + e.getMessage());
            }
        });
        return null;
    }

    protected void setupLineReader() throws IOException {
        LineReaderBuilder builder = LineReaderBuilder.builder();
        builder.variable("bell-style", (Object)"audible");
        Arrays.stream(CliDriver.getCommandCompleter()).forEach(arg_0 -> ((LineReaderBuilder)builder).completer(arg_0));
        builder.terminal(TerminalBuilder.terminal());
        builder.parser((Parser)CliDriver.getDefaultParser());
        builder.history((History)new DefaultHistory());
        String historyFile = this.setupCmdHistory();
        if (historyFile != null) {
            builder.variable("history-file", (Object)historyFile);
        }
        this.reader = builder.build();
    }

    static DefaultParser getDefaultParser() {
        return new DefaultParser(){

            public boolean isDelimiterChar(CharSequence buffer, int pos) {
                char c = buffer.charAt(pos);
                return Character.isWhitespace(c) || c == '(' || c == ')' || c == '[' || c == ']';
            }
        };
    }

    private static String getFormattedDb(HiveConf conf, CliSessionState ss) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.CLI_PRINT_CURRENT_DB)) {
            return "";
        }
        String currDb = SessionState.get().getCurrentDatabase();
        if (currDb == null) {
            return "";
        }
        return " (" + currDb + ")";
    }

    private static String spacesForString(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return String.format("%1$-" + s.length() + "s", "");
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        SessionState.get().setHiveVariables(hiveVariables);
    }
}

