/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.sdk.internal.AttributesMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.OTELJavaMetrics;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTELExporter
extends Thread {
    private static final String QUERY_SCOPE = OTELExporter.class.getName();
    private static final String JVM_SCOPE = OTELJavaMetrics.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(OTELExporter.class);
    private final OperationManager operationManager;
    private final Set<String> historicalQueryId;
    private final long frequency;
    private final Tracer tracer;
    private final Map<String, Span> queryIdToSpanMap;
    private final Map<String, Set<String>> queryIdToTasksMap;
    private final OTELJavaMetrics jvmMetrics;

    public OTELExporter(OpenTelemetry openTelemetry, SessionManager sessionManager, long frequency, String addr) {
        this.tracer = openTelemetry.getTracer(QUERY_SCOPE + ":" + addr);
        this.jvmMetrics = new OTELJavaMetrics(openTelemetry.getMeter(JVM_SCOPE + ":" + addr));
        this.operationManager = sessionManager.getOperationManager();
        this.historicalQueryId = new HashSet<String>();
        this.frequency = frequency;
        this.queryIdToSpanMap = new HashMap<String, Span>();
        this.queryIdToTasksMap = new HashMap<String, Set<String>>();
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.jvmMetrics.setJvmMetrics();
                this.exposeMetricsToOTEL();
            }
            catch (Throwable e) {
                LOG.error("Exception occurred in OTELExporter thread ", e);
            }
            try {
                Thread.sleep(this.frequency);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void exposeMetricsToOTEL() {
        Context parentContext;
        List<QueryInfo> liveQueries = this.operationManager.getLiveQueryInfos();
        List<QueryInfo> historicalQueries = this.operationManager.getHistoricalQueryInfos();
        LOG.debug("Found {} liveQueries and {} historicalQueries", (Object)liveQueries.size(), (Object)historicalQueries.size());
        for (QueryInfo lQuery : liveQueries) {
            if (lQuery.getQueryDisplay() == null || StringUtils.isEmpty((CharSequence)lQuery.getQueryDisplay().getQueryId())) continue;
            String queryID = lQuery.getQueryDisplay().getQueryId();
            Span rootspan = this.queryIdToSpanMap.get(queryID);
            if (rootspan != null) {
                for (QueryDisplay.TaskDisplay task : lQuery.getQueryDisplay().getTaskDisplays()) {
                    if (task.getReturnValue() == null || task.getEndTime() == null || !this.queryIdToTasksMap.get(queryID).add(task.getTaskId())) continue;
                    parentContext = Context.current().with((ImplicitContextKeyed)rootspan);
                    this.tracer.spanBuilder(queryID + " - " + task.getTaskId()).setParent(parentContext).setAllAttributes((Attributes)this.addTaskAttributes(task)).setStartTimestamp(task.getBeginTime().longValue(), TimeUnit.MILLISECONDS).startSpan().end(task.getEndTime().longValue(), TimeUnit.MILLISECONDS);
                }
                continue;
            }
            rootspan = this.tracer.spanBuilder(queryID).setStartTimestamp(lQuery.getBeginTime(), TimeUnit.MILLISECONDS).startSpan();
            HashSet<String> completedTasks = new HashSet<String>();
            Context parentContext2 = Context.current().with((ImplicitContextKeyed)rootspan);
            Span initSpan = this.tracer.spanBuilder(queryID).setParent(parentContext2).setStartTimestamp(lQuery.getBeginTime(), TimeUnit.MILLISECONDS).startSpan().setAttribute("QueryId", queryID).setAttribute("QueryString", lQuery.getQueryDisplay().getQueryString()).setAttribute("UserName", lQuery.getUserName()).setAttribute("ExecutionEngine", lQuery.getExecutionEngine());
            if (lQuery.getQueryDisplay().getErrorMessage() != null) {
                initSpan.setAttribute("ErrorMessage", lQuery.getQueryDisplay().getErrorMessage());
            }
            initSpan.end(lQuery.getBeginTime(), TimeUnit.MILLISECONDS);
            for (QueryDisplay.TaskDisplay task : lQuery.getQueryDisplay().getTaskDisplays()) {
                if (task.getReturnValue() == null || task.getEndTime() == null) continue;
                completedTasks.add(task.getTaskId());
                parentContext2 = Context.current().with((ImplicitContextKeyed)rootspan);
                this.tracer.spanBuilder(queryID + " - " + task.getTaskId()).setParent(parentContext2).setAllAttributes((Attributes)this.addTaskAttributes(task)).setStartTimestamp(task.getBeginTime().longValue(), TimeUnit.MILLISECONDS).startSpan().end(task.getEndTime().longValue(), TimeUnit.MILLISECONDS);
            }
            this.queryIdToSpanMap.put(queryID, rootspan);
            this.queryIdToTasksMap.put(queryID, completedTasks);
        }
        HashSet<String> historicalQueryIDs = new HashSet<String>();
        for (QueryInfo hQuery : historicalQueries) {
            if (hQuery.getEndTime() == null) continue;
            String hQueryId = hQuery.getQueryDisplay().getQueryId();
            historicalQueryIDs.add(hQueryId);
            Span rootspan = this.queryIdToSpanMap.remove(hQueryId);
            Set<String> completedTasks = this.queryIdToTasksMap.remove(hQueryId);
            if (rootspan != null) {
                for (QueryDisplay.TaskDisplay task : hQuery.getQueryDisplay().getTaskDisplays()) {
                    if (completedTasks.contains(task.getTaskId())) continue;
                    Context parentContext3 = Context.current().with((ImplicitContextKeyed)rootspan);
                    this.tracer.spanBuilder(hQueryId + " - " + task.getTaskId()).setParent(parentContext3).setAllAttributes((Attributes)this.addTaskAttributes(task)).setStartTimestamp(task.getBeginTime().longValue(), TimeUnit.MILLISECONDS).startSpan().end(task.getEndTime().longValue(), TimeUnit.MILLISECONDS);
                }
                rootspan.updateName(hQueryId + " - completed").setAllAttributes((Attributes)this.addQueryAttributes(hQuery)).end(hQuery.getEndTime().longValue(), TimeUnit.MILLISECONDS);
                this.historicalQueryId.add(hQueryId);
            }
            if (!this.historicalQueryId.add(hQueryId)) continue;
            rootspan = this.tracer.spanBuilder(hQueryId + " - completed").setStartTimestamp(hQuery.getBeginTime(), TimeUnit.MILLISECONDS).startSpan();
            parentContext = Context.current().with((ImplicitContextKeyed)rootspan);
            Span initSpan = this.tracer.spanBuilder(hQueryId).setParent(parentContext).setStartTimestamp(hQuery.getBeginTime(), TimeUnit.MILLISECONDS).startSpan().setAttribute("QueryId", hQueryId).setAttribute("QueryString", hQuery.getQueryDisplay().getQueryString()).setAttribute("UserName", hQuery.getUserName()).setAttribute("ExecutionEngine", hQuery.getExecutionEngine());
            if (hQuery.getQueryDisplay().getErrorMessage() != null) {
                initSpan.setAttribute("ErrorMessage", hQuery.getQueryDisplay().getErrorMessage());
            }
            initSpan.end(hQuery.getBeginTime(), TimeUnit.MILLISECONDS);
            for (QueryDisplay.TaskDisplay task : hQuery.getQueryDisplay().getTaskDisplays()) {
                parentContext = Context.current().with((ImplicitContextKeyed)rootspan);
                this.tracer.spanBuilder(hQueryId + " - " + task.getTaskId()).setParent(parentContext).setAllAttributes((Attributes)this.addTaskAttributes(task)).setStartTimestamp(task.getBeginTime().longValue(), TimeUnit.MILLISECONDS).startSpan().end(task.getEndTime().longValue(), TimeUnit.MILLISECONDS);
            }
            rootspan.setAllAttributes((Attributes)this.addQueryAttributes(hQuery)).end(hQuery.getEndTime().longValue(), TimeUnit.MILLISECONDS);
        }
        this.historicalQueryId.retainAll(historicalQueryIDs);
    }

    private AttributesMap addQueryAttributes(QueryInfo query) {
        AttributesMap attributes = AttributesMap.create((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        attributes.put(AttributeKey.stringKey((String)"QueryId"), (Object)query.getQueryDisplay().getQueryId());
        attributes.put(AttributeKey.longKey((String)"QueryStartTime"), (Object)query.getQueryDisplay().getQueryStartTime());
        attributes.put(AttributeKey.longKey((String)"EndTime"), (Object)query.getEndTime());
        attributes.put(AttributeKey.stringKey((String)"OperationId"), (Object)query.getOperationId());
        attributes.put(AttributeKey.stringKey((String)"OperationLogLocation"), (Object)query.getOperationLogLocation());
        attributes.put(AttributeKey.stringKey((String)"ErrorMessage"), (Object)query.getQueryDisplay().getErrorMessage());
        attributes.put(AttributeKey.stringKey((String)"ExplainPlan"), (Object)query.getQueryDisplay().getExplainPlan());
        attributes.put(AttributeKey.stringKey((String)"FullLogLocation"), (Object)query.getQueryDisplay().getFullLogLocation());
        attributes.put(AttributeKey.stringKey((String)"Running"), (Object)String.valueOf(query.isRunning()));
        attributes.put(AttributeKey.longKey((String)"Runtime"), (Object)query.getRuntime());
        attributes.put(AttributeKey.stringKey((String)"UserName"), (Object)query.getUserName());
        attributes.put(AttributeKey.stringKey((String)"State"), (Object)query.getState());
        attributes.put(AttributeKey.stringKey((String)"SessionId"), (Object)query.getSessionId());
        return attributes;
    }

    private AttributesMap addTaskAttributes(QueryDisplay.TaskDisplay taskDisplay) {
        AttributesMap attributes = AttributesMap.create((long)Long.MAX_VALUE, (int)Integer.MAX_VALUE);
        attributes.put(AttributeKey.stringKey((String)"TaskId"), (Object)taskDisplay.getTaskId());
        attributes.put(AttributeKey.stringKey((String)"Name"), (Object)taskDisplay.getName());
        if (taskDisplay.getTaskType() != null) {
            attributes.put(AttributeKey.stringKey((String)"TaskType"), (Object)taskDisplay.getTaskType().toString());
        }
        attributes.put(AttributeKey.stringKey((String)"Status"), (Object)taskDisplay.getStatus());
        attributes.put(AttributeKey.stringKey((String)"StatusMessage"), (Object)taskDisplay.getStatusMessage());
        attributes.put(AttributeKey.stringKey((String)"ExternalHandle"), (Object)taskDisplay.getExternalHandle());
        attributes.put(AttributeKey.stringKey((String)"ErrorMsg"), (Object)taskDisplay.getErrorMsg());
        if (taskDisplay.getReturnValue() != null) {
            attributes.put(AttributeKey.longKey((String)"ReturnValue"), (Object)taskDisplay.getReturnValue().longValue());
        }
        attributes.put(AttributeKey.longKey((String)"BeginTime"), (Object)taskDisplay.getBeginTime());
        attributes.put(AttributeKey.longKey((String)"ElapsedTime"), (Object)taskDisplay.getElapsedTime());
        attributes.put(AttributeKey.longKey((String)"EndTime"), (Object)taskDisplay.getEndTime());
        return attributes;
    }
}

