/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TOperationState;

public enum OperationState {
    INITIALIZED(TOperationState.INITIALIZED_STATE, false),
    RUNNING(TOperationState.RUNNING_STATE, false),
    FINISHED(TOperationState.FINISHED_STATE, true),
    CANCELED(TOperationState.CANCELED_STATE, true),
    CLOSED(TOperationState.CLOSED_STATE, true),
    ERROR(TOperationState.ERROR_STATE, true),
    UNKNOWN(TOperationState.UKNOWN_STATE, false),
    PENDING(TOperationState.PENDING_STATE, false),
    TIMEDOUT(TOperationState.TIMEDOUT_STATE, true);

    private final TOperationState tOperationState;
    private final boolean terminal;
    private String errorMessage;

    private OperationState(TOperationState tOperationState, boolean terminal) {
        this.tOperationState = tOperationState;
        this.terminal = terminal;
    }

    public static OperationState getOperationState(TOperationState tOperationState) {
        return OperationState.values()[tOperationState.getValue()];
    }

    public static void validateTransition(OperationState oldState, OperationState newState) throws HiveSQLException {
        switch (oldState.ordinal()) {
            case 0: {
                switch (newState.ordinal()) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
            case 7: {
                switch (newState.ordinal()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
            case 1: {
                switch (newState.ordinal()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                if (!CLOSED.equals((Object)newState)) break;
                return;
            }
        }
        throw new HiveSQLException("Illegal Operation state transition from " + String.valueOf((Object)oldState) + " to " + String.valueOf((Object)newState));
    }

    public void validateTransition(OperationState newState) throws HiveSQLException {
        OperationState.validateTransition(this, newState);
    }

    public TOperationState toTOperationState() {
        return this.tOperationState;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

