/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.TypeUtil;

public class ReflectionHelper {
    private RuleFactory ruleFactory;

    public ReflectionHelper(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    public JType getSuperType(String nodeName, JsonNode node, JPackage jPackage, Schema schema) {
        if (node.has("extends") && node.has("extendsJavaClass")) {
            throw new IllegalStateException("'extends' and 'extendsJavaClass' defined simultaneously");
        }
        JType superType = jPackage.owner().ref(Object.class);
        Schema superTypeSchema = this.getSuperSchema(node, schema, false);
        if (superTypeSchema != null) {
            superType = this.ruleFactory.getSchemaRule().apply(nodeName + "Parent", node.get("extends"), node, jPackage, superTypeSchema);
        } else if (node.has("extendsJavaClass")) {
            superType = TypeUtil.resolveType(jPackage, node.get("extendsJavaClass").asText());
        }
        return superType;
    }

    public Schema getSuperSchema(JsonNode node, Schema schema, boolean followRefs) {
        if (node.has("extends")) {
            String path = schema.getId().getFragment() == null ? "#extends" : "#" + schema.getId().getFragment() + "/extends";
            Schema superSchema = this.ruleFactory.getSchemaStore().create(schema, path, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            if (followRefs) {
                superSchema = this.resolveSchemaRefsRecursive(superSchema);
            }
            return superSchema;
        }
        return null;
    }

    public JFieldVar searchSuperClassesForField(String property, JDefinedClass jclass) {
        JClass superClass = jclass._extends();
        JDefinedClass definedSuperClass = this.definedClassOrNullFromType(superClass);
        if (definedSuperClass == null) {
            return null;
        }
        return this.searchClassAndSuperClassesForField(property, definedSuperClass);
    }

    public JDefinedClass getBuilderClass(JDefinedClass target) {
        String builderClassname = this.ruleFactory.getNameHelper().getBuilderClassName(target);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(target.classes(), 16), false).filter(definedClass -> definedClass.name().equals(builderClassname)).findFirst().orElse(null);
    }

    public JDefinedClass getBuilderClass(JClass target) {
        String builderClassname = this.ruleFactory.getNameHelper().getBuilderClassName(target);
        return this.getAllPackageClasses(target._package()).stream().filter(definedClass -> definedClass.name().equals(builderClassname)).findFirst().orElse(null);
    }

    public boolean isFinal(JType superType) {
        try {
            Class<?> javaClass = Class.forName(superType.fullName());
            return Modifier.isFinal(javaClass.getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public JFieldVar searchClassAndSuperClassesForField(String property, JDefinedClass jclass) {
        Map<String, JFieldVar> fields = jclass.fields();
        JFieldVar field = fields.get(property);
        if (field == null) {
            return this.searchSuperClassesForField(property, jclass);
        }
        return field;
    }

    private JDefinedClass definedClassOrNullFromType(JType type) {
        if (type == null || type.isPrimitive()) {
            return null;
        }
        JClass fieldClass = type.boxify();
        JPackage jPackage = fieldClass._package();
        return this._getClass(fieldClass.name(), jPackage);
    }

    private JDefinedClass _getClass(String name, JPackage _package) {
        return this.getAllPackageClasses(_package).stream().filter(definedClass -> definedClass.name().equals(name)).findFirst().orElseThrow(() -> new NoClassDefFoundError(name));
    }

    private Collection<JDefinedClass> getAllPackageClasses(JPackage _package) {
        LinkedList<JDefinedClass> result = new LinkedList<JDefinedClass>();
        StreamSupport.stream(Spliterators.spliteratorUnknownSize(_package.classes(), 16), false).forEach(_class -> result.addAll(this.getAllClassClasses((JDefinedClass)_class)));
        return result;
    }

    private Collection<JDefinedClass> getAllClassClasses(JDefinedClass _class) {
        LinkedList<JDefinedClass> result = new LinkedList<JDefinedClass>();
        result.add(_class);
        _class.classes().forEachRemaining(result::add);
        return result;
    }

    private Schema resolveSchemaRefsRecursive(Schema schema) {
        JsonNode schemaNode = schema.getContent();
        if (schemaNode.has("$ref")) {
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            return this.resolveSchemaRefsRecursive(schema);
        }
        return schema;
    }
}

