/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.org.apache.http.HttpException;
import org.apache.hive.org.apache.http.HttpRequest;
import org.apache.hive.org.apache.http.client.CookieStore;
import org.apache.hive.org.apache.http.protocol.HttpContext;
import org.apache.hive.service.auth.HttpAuthUtils;

public class HttpKerberosRequestInterceptor
extends HttpRequestInterceptorBase {
    String principal;
    String host;
    String serverHttpUrl;
    Subject loggedInSubject;
    private static ReentrantLock kerberosLock = new ReentrantLock(true);

    public HttpKerberosRequestInterceptor(String principal, String host, String serverHttpUrl, Subject loggedInSubject, CookieStore cs, String cn, boolean isSSL, Map<String, String> additionalHeaders, Map<String, String> customCookies) {
        super(cs, cn, isSSL, additionalHeaders, customCookies);
        this.principal = principal;
        this.host = host;
        this.serverHttpUrl = serverHttpUrl;
        this.loggedInSubject = loggedInSubject;
    }

    @Override
    protected void addHttpAuthHeader(HttpRequest httpRequest, HttpContext httpContext) throws Exception {
        try {
            kerberosLock.lock();
            String kerberosAuthHeader = HttpAuthUtils.getKerberosServiceTicket(this.principal, this.host, this.serverHttpUrl, this.loggedInSubject);
            httpRequest.addHeader("Authorization: Negotiate ", kerberosAuthHeader);
        }
        catch (Exception e) {
            throw new HttpException("Failed to find any Kerberos ticket", e);
        }
        finally {
            kerberosLock.unlock();
        }
    }
}

