/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreUtils;
import org.apache.hadoop.hive.metastore.StorageSchemaReader;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.serde2.Deserializer;

public class SerDeStorageSchemaReader
implements StorageSchemaReader {
    public List<FieldSchema> readSchema(Table tbl, EnvironmentContext envContext, Configuration conf) throws MetaException {
        List<FieldSchema> list;
        block6: {
            ClassLoader orgHiveLoader = null;
            try {
                String addedJars;
                if (envContext != null && StringUtils.isNotBlank((CharSequence)(addedJars = (String)envContext.getProperties().get("hive.added.jars.path")))) {
                    orgHiveLoader = conf.getClassLoader();
                    ClassLoader loader = MetaStoreUtils.addToClassPath((ClassLoader)orgHiveLoader, (String[])StringUtils.split((String)addedJars, (String)","));
                    conf.setClassLoader(loader);
                }
                Deserializer s = HiveMetaStoreUtils.getDeserializer(conf, tbl, null, false);
                list = HiveMetaStoreUtils.getFieldsFromDeserializer(tbl.getTableName(), s, conf);
                if (orgHiveLoader == null) break block6;
            }
            catch (Exception e) {
                try {
                    throw new MetaException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (orgHiveLoader != null) {
                        conf.setClassLoader(orgHiveLoader);
                    }
                    throw throwable;
                }
            }
            conf.setClassLoader(orgHiveLoader);
        }
        return list;
    }
}

