/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableCommit;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.hadoop.Configurable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTSessionCatalog;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;

public class RESTCatalog
implements Catalog,
ViewCatalog,
SupportsNamespaces,
Configurable<Object>,
Closeable {
    private final RESTSessionCatalog sessionCatalog;
    private final Catalog delegate;
    private final SupportsNamespaces nsDelegate;
    private final SessionCatalog.SessionContext context;
    private final ViewCatalog viewSessionCatalog;

    public RESTCatalog() {
        this(SessionCatalog.SessionContext.createEmpty(), config -> HTTPClient.builder(config).uri((String)config.get("uri")).withHeaders(RESTUtil.configHeaders(config)).build());
    }

    public RESTCatalog(Function<Map<String, String>, RESTClient> clientBuilder) {
        this(SessionCatalog.SessionContext.createEmpty(), clientBuilder);
    }

    public RESTCatalog(SessionCatalog.SessionContext context, Function<Map<String, String>, RESTClient> clientBuilder) {
        this.sessionCatalog = new RESTSessionCatalog(clientBuilder, null);
        this.delegate = this.sessionCatalog.asCatalog(context);
        this.nsDelegate = (SupportsNamespaces)((Object)this.delegate);
        this.context = context;
        this.viewSessionCatalog = this.sessionCatalog.asViewCatalog(context);
    }

    @Override
    public void initialize(String name, Map<String, String> props) {
        Preconditions.checkArgument(props != null, "Invalid configuration: null");
        this.sessionCatalog.initialize(name, props);
    }

    @Override
    public String name() {
        return this.sessionCatalog.name();
    }

    public Map<String, String> properties() {
        return this.sessionCatalog.properties();
    }

    @Override
    public List<TableIdentifier> listTables(Namespace ns) {
        return this.delegate.listTables(ns);
    }

    @Override
    public boolean tableExists(TableIdentifier ident) {
        return this.delegate.tableExists(ident);
    }

    @Override
    public Table loadTable(TableIdentifier ident) {
        return this.delegate.loadTable(ident);
    }

    @Override
    public void invalidateTable(TableIdentifier ident) {
        this.delegate.invalidateTable(ident);
    }

    @Override
    public Catalog.TableBuilder buildTable(TableIdentifier ident, Schema schema) {
        return this.delegate.buildTable(ident, schema);
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props) {
        return this.delegate.createTable(ident, schema, spec, location, props);
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props) {
        return this.delegate.createTable(ident, schema, spec, props);
    }

    @Override
    public Table createTable(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        return this.delegate.createTable(ident, schema, spec);
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema) {
        return this.delegate.createTable(identifier, schema);
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec, location, props);
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec, props);
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec) {
        return this.delegate.newCreateTableTransaction(ident, schema, spec);
    }

    @Override
    public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema) {
        return this.delegate.newCreateTableTransaction(identifier, schema);
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, String location, Map<String, String> props, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, location, props, orCreate);
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, Map<String, String> props, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, props, orCreate);
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, PartitionSpec spec, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, spec, orCreate);
    }

    @Override
    public Transaction newReplaceTableTransaction(TableIdentifier ident, Schema schema, boolean orCreate) {
        return this.delegate.newReplaceTableTransaction(ident, schema, orCreate);
    }

    @Override
    public boolean dropTable(TableIdentifier ident) {
        return this.delegate.dropTable(ident);
    }

    @Override
    public boolean dropTable(TableIdentifier ident, boolean purge) {
        return this.delegate.dropTable(ident, purge);
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier to) {
        this.delegate.renameTable(from, to);
    }

    @Override
    public Table registerTable(TableIdentifier ident, String metadataFileLocation) {
        return this.delegate.registerTable(ident, metadataFileLocation);
    }

    @Override
    public void createNamespace(Namespace ns, Map<String, String> props) {
        this.nsDelegate.createNamespace(ns, props);
    }

    @Override
    public List<Namespace> listNamespaces(Namespace ns) throws NoSuchNamespaceException {
        return this.nsDelegate.listNamespaces(ns);
    }

    @Override
    public boolean namespaceExists(Namespace namespace) {
        return this.nsDelegate.namespaceExists(namespace);
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace ns) throws NoSuchNamespaceException {
        return this.nsDelegate.loadNamespaceMetadata(ns);
    }

    @Override
    public boolean dropNamespace(Namespace ns) throws NamespaceNotEmptyException {
        return this.nsDelegate.dropNamespace(ns);
    }

    @Override
    public boolean setProperties(Namespace ns, Map<String, String> props) throws NoSuchNamespaceException {
        return this.nsDelegate.setProperties(ns, props);
    }

    @Override
    public boolean removeProperties(Namespace ns, Set<String> props) throws NoSuchNamespaceException {
        return this.nsDelegate.removeProperties(ns, props);
    }

    @Override
    public void setConf(Object conf) {
        this.sessionCatalog.setConf(conf);
    }

    @Override
    public void close() throws IOException {
        this.sessionCatalog.close();
    }

    public void commitTransaction(List<TableCommit> commits) {
        this.sessionCatalog.commitTransaction(this.context, commits);
    }

    public void commitTransaction(TableCommit ... commits) {
        this.sessionCatalog.commitTransaction(this.context, (List<TableCommit>)((Object)((ImmutableList.Builder)ImmutableList.builder().add(commits)).build()));
    }

    @Override
    public List<TableIdentifier> listViews(Namespace namespace) {
        return this.viewSessionCatalog.listViews(namespace);
    }

    @Override
    public View loadView(TableIdentifier identifier) {
        return this.viewSessionCatalog.loadView(identifier);
    }

    @Override
    public ViewBuilder buildView(TableIdentifier identifier) {
        return this.viewSessionCatalog.buildView(identifier);
    }

    @Override
    public boolean dropView(TableIdentifier identifier) {
        return this.viewSessionCatalog.dropView(identifier);
    }

    @Override
    public void renameView(TableIdentifier from, TableIdentifier to) {
        this.viewSessionCatalog.renameView(from, to);
    }

    @Override
    public boolean viewExists(TableIdentifier identifier) {
        return this.viewSessionCatalog.viewExists(identifier);
    }

    @Override
    public void invalidateView(TableIdentifier identifier) {
        this.viewSessionCatalog.invalidateView(identifier);
    }
}

