/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.tuple.State;
import org.apache.datasketches.hive.tuple.UnionState;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;

abstract class SketchEvaluator<S extends Summary>
extends GenericUDAFEvaluator {
    protected static final String NOMINAL_NUM_ENTRIES_FIELD = "nominalEntries";
    protected static final String SKETCH_FIELD = "sketch";
    protected PrimitiveObjectInspector nominalNumEntriesInspector_;
    protected StructObjectInspector intermediateInspector_;

    SketchEvaluator() {
    }

    protected abstract SummaryDeserializer<S> getSummaryDeserializer();

    protected abstract SummaryFactory<S> getSummaryFactory(Object[] var1);

    protected abstract SummarySetOperations<S> getSummarySetOperationsForIterate(Object[] var1);

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        Sketch intermediate = state.getResult();
        if (intermediate == null) {
            return null;
        }
        byte[] bytes = intermediate.toByteArray();
        return Arrays.asList(new IntWritable(state.getNominalNumEntries()), new BytesWritable(bytes));
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        UnionState state = (UnionState)buf;
        if (!state.isInitialized()) {
            this.initializeState(state, data);
        }
        BytesWritable serializedSketch = (BytesWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(SKETCH_FIELD));
        state.update(Sketches.heapifySketch((Memory)BytesWritableHelper.wrapAsMemory(serializedSketch), this.getSummaryDeserializer()));
    }

    protected void initializeState(UnionState<S> state, Object data) {
        int nominalNumEntries = ((IntWritable)this.intermediateInspector_.getStructFieldData(data, this.intermediateInspector_.getStructFieldRef(NOMINAL_NUM_ENTRIES_FIELD))).get();
        state.init(nominalNumEntries, this.getSummarySetOperationsForMerge(data));
    }

    protected abstract SummarySetOperations<S> getSummarySetOperationsForMerge(Object var1);

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        if (state == null) {
            return null;
        }
        Sketch result = state.getResult();
        if (result == null) {
            return null;
        }
        return new BytesWritable(result.toByteArray());
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        State state = (State)buf;
        state.reset();
    }
}

