/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.util.Queue;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyChunk;
import org.asynchttpclient.request.body.generator.FeedListener;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.asynchttpclient.request.body.generator.PushBody;

public abstract class QueueBasedFeedableBodyGenerator<T extends Queue<BodyChunk>>
implements FeedableBodyGenerator {
    protected final T queue;
    private FeedListener listener;

    public QueueBasedFeedableBodyGenerator(T queue) {
        this.queue = queue;
    }

    @Override
    public Body createBody() {
        return new PushBody((Queue<BodyChunk>)this.queue);
    }

    protected abstract boolean offer(BodyChunk var1) throws Exception;

    @Override
    public boolean feed(ByteBuf buffer, boolean isLast) throws Exception {
        boolean offered = this.offer(new BodyChunk(buffer, isLast));
        if (offered && this.listener != null) {
            this.listener.onContentAdded();
        }
        return offered;
    }

    @Override
    public void setListener(FeedListener listener) {
        this.listener = listener;
    }
}

