/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import com.typesafe.netty.HandlerSubscriber;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultHttpContent;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpContent;
import org.apache.hive.druid.io.netty.handler.codec.http.LastHttpContent;
import org.apache.hive.druid.io.netty.util.concurrent.EventExecutor;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.util.Assertions;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyReactiveStreamsBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyReactiveStreamsBody.class);
    private static final String NAME_IN_CHANNEL_PIPELINE = "request-body-streamer";
    private final Publisher<ByteBuf> publisher;
    private final long contentLength;

    public NettyReactiveStreamsBody(Publisher<ByteBuf> publisher, long contentLength) {
        this.publisher = publisher;
        this.contentLength = contentLength;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        if (future.isStreamConsumed()) {
            LOGGER.warn("Stream has already been consumed and cannot be reset");
        } else {
            future.setStreamConsumed(true);
            NettySubscriber subscriber = new NettySubscriber(channel, future);
            channel.pipeline().addLast(NAME_IN_CHANNEL_PIPELINE, (ChannelHandler)subscriber);
            this.publisher.subscribe((Subscriber)new SubscriberAdapter((Subscriber<HttpContent>)subscriber));
            subscriber.delayedStart();
        }
    }

    private static class NettySubscriber
    extends HandlerSubscriber<HttpContent> {
        private static final Logger LOGGER = LoggerFactory.getLogger(NettySubscriber.class);
        private static final Subscription DO_NOT_DELAY = new Subscription(){

            public void cancel() {
            }

            public void request(long l) {
            }
        };
        private final Channel channel;
        private final NettyResponseFuture<?> future;
        private AtomicReference<Subscription> deferredSubscription = new AtomicReference();

        NettySubscriber(Channel channel, NettyResponseFuture<?> future) {
            super((EventExecutor)channel.eventLoop());
            this.channel = channel;
            this.future = future;
        }

        protected void complete() {
            this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener(future -> this.removeFromPipeline()));
        }

        public void onSubscribe(Subscription subscription) {
            if (!this.deferredSubscription.compareAndSet(null, subscription)) {
                super.onSubscribe(subscription);
            }
        }

        void delayedStart() {
            Subscription subscription = this.deferredSubscription.getAndSet(DO_NOT_DELAY);
            if (subscription != null) {
                super.onSubscribe(subscription);
            }
        }

        protected void error(Throwable error) {
            Assertions.assertNotNull(error, "error");
            this.removeFromPipeline();
            this.future.abort(error);
        }

        private void removeFromPipeline() {
            try {
                this.channel.pipeline().remove((ChannelHandler)this);
                LOGGER.debug(String.format("Removed handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE));
            }
            catch (NoSuchElementException e) {
                LOGGER.debug(String.format("Failed to remove handler %s from pipeline.", NettyReactiveStreamsBody.NAME_IN_CHANNEL_PIPELINE), (Throwable)e);
            }
        }
    }

    private static class SubscriberAdapter
    implements Subscriber<ByteBuf> {
        private final Subscriber<HttpContent> subscriber;

        SubscriberAdapter(Subscriber<HttpContent> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onNext(ByteBuf buffer) {
            DefaultHttpContent content = new DefaultHttpContent(buffer);
            this.subscriber.onNext((Object)content);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

