/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.channel.ConnectionSemaphore;
import org.asynchttpclient.netty.channel.ConnectionSemaphoreFactory;
import org.asynchttpclient.netty.channel.MaxConnectionSemaphore;
import org.asynchttpclient.netty.channel.NoopConnectionSemaphore;
import org.asynchttpclient.netty.channel.PerHostConnectionSemaphore;

public class DefaultConnectionSemaphoreFactory
implements ConnectionSemaphoreFactory {
    @Override
    public ConnectionSemaphore newConnectionSemaphore(AsyncHttpClientConfig config) {
        ConnectionSemaphore semaphore = new NoopConnectionSemaphore();
        if (config.getMaxConnections() > 0) {
            semaphore = new MaxConnectionSemaphore(config.getMaxConnections());
        }
        if (config.getMaxConnectionsPerHost() > 0) {
            semaphore = new PerHostConnectionSemaphore(config.getMaxConnectionsPerHost(), semaphore);
        }
        return semaphore;
    }
}

